/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.zip;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class CUtilZip {
    private CUtilZip() {
    }

    public static void pack(final Path aFolder, Path aZipFilePath) throws IOException {
        final String source = aFolder.toFile().getName() + File.separator;
        final AtomicLong oldest = new AtomicLong();
        File zip = aZipFilePath.toFile();
        try (FileOutputStream fos = new FileOutputStream(zip);
             final ZipOutputStream zos = new ZipOutputStream(fos);){
            Files.walkFileTree(aFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String s = source + aFolder.relativize(dir) + "/";
                    ZipEntry zipEntry = new ZipEntry(s);
                    long time = dir.toFile().lastModified();
                    if (time > oldest.get()) {
                        oldest.set(time);
                    }
                    zipEntry.setTime(time);
                    zos.putNextEntry(zipEntry);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String s = source + aFolder.relativize(file);
                    ZipEntry zipEntry = new ZipEntry(s);
                    long time = file.toFile().lastModified();
                    if (time > oldest.get()) {
                        oldest.set(time);
                    }
                    zipEntry.setTime(time);
                    zos.putNextEntry(zipEntry);
                    Files.copy(file, zos);
                    zos.closeEntry();
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        zip.setLastModified(oldest.get());
    }
}

