/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.time;

public class CUtilDuration {
    public static final long ONE_SECOND = 1000L;
    public static final long SECONDS = 60L;
    public static final long ONE_MINUTE = 60000L;
    public static final long MINUTES = 60L;
    public static final long ONE_HOUR = 3600000L;
    public static final long HOURS = 24L;
    public static final long ONE_DAY = 86400000L;

    private CUtilDuration() {
    }

    public static String millisToLongDHMS(long duration) {
        StringBuilder res = new StringBuilder();
        if (duration >= 1000L) {
            long temp = duration / 86400000L;
            if (temp > 0L) {
                res.append(temp).append(" day").append(temp > 1L ? "s" : "").append((duration -= temp * 86400000L) >= 60000L ? ", " : "");
            }
            if ((temp = duration / 3600000L) > 0L) {
                res.append(temp).append(" hour").append(temp > 1L ? "s" : "").append((duration -= temp * 3600000L) >= 60000L ? ", " : "");
            }
            if ((temp = duration / 60000L) > 0L) {
                duration -= temp * 60000L;
                res.append(temp).append(" minute").append(temp > 1L ? "s" : "");
            }
            if (!res.toString().equals("") && duration >= 1000L) {
                res.append(" and ");
            }
            if ((temp = duration / 1000L) > 0L) {
                res.append(temp).append(" second").append(temp > 1L ? "s" : "");
            }
            return res.toString();
        }
        return "0 second";
    }

    public static String millisToShortDHMS(long duration) {
        int seconds = (int)((duration /= 1000L) % 60L);
        int minutes = (int)((duration /= 60L) % 60L);
        int hours = (int)((duration /= 60L) % 24L);
        int days = (int)(duration / 24L);
        String res = days == 0 ? String.format("%02d:%02d:%02d", hours, minutes, seconds) : String.format("%dd%02d:%02d:%02d", days, hours, minutes, seconds);
        return res;
    }
}

