/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.hash;

import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.hash.CHashFactory;
import de.sillysky.nyssr.util.hash.EHashType;
import de.sillysky.nyssr.util.hash.IDigest;
import de.sillysky.nyssr.util.string.CUtilBase64;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class CUtilPassword {
    private CUtilPassword() {
    }

    @Contract(pure=true)
    @Nullable
    public static String hashPassword(char[] aPassword) {
        byte[] bytes = CUtilByteArray.fromCharArray(aPassword);
        IDigest digest = CHashFactory.createEmpty(EHashType.SHA384);
        if (digest != null) {
            digest.update(bytes, 0, bytes.length);
            digest.digest();
            byte[] encoded = digest.getByteArray();
            return CUtilBase64.encodeToString(encoded);
        }
        return null;
    }
}

