/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.files.CResourceHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public final class CUtilCompress {
    private CUtilCompress() {
    }

    public static byte[] compress(final byte[] aData) {
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            @Override
            protected byte[] doResourceHandling() throws Exception {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                this.registerResource(bos);
                GZIPOutputStream gos = new GZIPOutputStream(bos);
                this.registerResource(gos);
                gos.write(aData);
                gos.finish();
                return bos.toByteArray();
            }
        };
        CResult error = handler.run();
        if (error == null) {
            return (byte[])handler.getResult();
        }
        return null;
    }

    public static byte[] uncompress(final byte[] aData, final int aUncompressedLength) {
        CResourceHandler<byte[]> handler = new CResourceHandler<byte[]>(){

            @Override
            protected byte[] doResourceHandling() throws Exception {
                ByteArrayInputStream bis = new ByteArrayInputStream(aData);
                this.registerResource(bis);
                GZIPInputStream gs = new GZIPInputStream(bis);
                this.registerResource(gs);
                DataInputStream dis = new DataInputStream(gs);
                this.registerResource(dis);
                byte[] uncompressed = new byte[aUncompressedLength];
                dis.readFully(uncompressed);
                return uncompressed;
            }
        };
        CResult error = handler.run();
        if (error == null) {
            return (byte[])handler.getResult();
        }
        return null;
    }
}

