/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class CPathValidator {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPathValidator.class);

    private CPathValidator() {
    }

    public static boolean isChildDirectory(File aMainDir, File aFileToCheck) throws IOException {
        File main = aMainDir.getCanonicalFile();
        for (File parentFile = aFileToCheck.getCanonicalFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
            if (!main.equals(parentFile)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChildDirectory(String aMainDir, String aFileToCheck) throws IOException {
        File main = new File(aMainDir);
        File fileToCheck = new File(aFileToCheck);
        return CPathValidator.isChildDirectory(main, fileToCheck);
    }

    public static boolean isChildDirectory2(String aMainDir, String aPathToCheck) {
        Path main = FileSystems.getDefault().getPath(aMainDir, new String[0]).normalize();
        Path check = FileSystems.getDefault().getPath(aPathToCheck, new String[0]).normalize();
        return check.startsWith(main);
    }

    public static String validatePath(String aMainPath, String aPathToCheck) {
        try {
            Path main = Paths.get(aMainPath, new String[0]);
            Path combined = Paths.get(aMainPath, aPathToCheck).normalize();
            if (!combined.isAbsolute()) {
                LOG.error("Path not absolute: {}", combined);
                return null;
            }
            if (!combined.startsWith(main)) {
                LOG.error("Path not relative to main directory: {}", combined);
                return null;
            }
            return combined.toString();
        }
        catch (Exception e) {
            LOG.error("Exception on path validation: " + e.getMessage());
            return null;
        }
    }

    public static String validatePath(String[] aMainPathes, String aPathToCheck) {
        for (String path : aMainPathes) {
            String allowed = CPathValidator.validatePath(path, aPathToCheck);
            if (allowed == null) continue;
            return allowed;
        }
        return null;
    }
}

