/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.files;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class CPathComponents {
    private final Path mInputPath;
    private String mName = "";
    private String mExt = "";
    private String mNameExt = "";
    private Path mPath = null;
    private Path mRoot = null;

    public CPathComponents(String aInputPath) {
        this.mInputPath = Paths.get(aInputPath, new String[0]);
        this.split();
    }

    public CPathComponents(Path aInputPath) {
        this.mInputPath = aInputPath;
        this.split();
    }

    public CPathComponents(File aFile) {
        this.mInputPath = aFile.toPath();
        this.split();
    }

    public String getExt() {
        return this.mExt;
    }

    public Path getInputPath() {
        return this.mInputPath;
    }

    public String getName() {
        return this.mName;
    }

    public String getNameExt() {
        return this.mNameExt;
    }

    public Path getPath() {
        return this.mPath;
    }

    public Path getRoot() {
        return this.mRoot;
    }

    private void split() {
        this.mName = "";
        this.mNameExt = "";
        this.mExt = "";
        this.mPath = null;
        this.mRoot = null;
        if (this.mInputPath != null && !this.mInputPath.toString().isEmpty()) {
            File f = this.mInputPath.toFile();
            this.mNameExt = f.getName();
            int pos = this.mNameExt.lastIndexOf(46);
            if (pos > 0) {
                this.mName = this.mNameExt.substring(0, pos);
                this.mExt = this.mNameExt.substring(pos);
            } else {
                this.mName = this.mNameExt;
            }
            while ((f = f.getParentFile()) != null) {
                if (this.mPath == null) {
                    this.mPath = f.toPath();
                }
                if (f.getParentFile() != null) continue;
            }
            if (f != null) {
                this.mRoot = f.toPath();
            }
        }
    }
}

