/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.arguments;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilByte;
import de.sillysky.nyssr.util.CUtilDouble;
import de.sillysky.nyssr.util.CUtilFloat;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilLong;
import de.sillysky.nyssr.util.CUtilShort;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.CStringProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CArgumentList {
    private static final String DELIMITER = ",";
    private static final int ORIGINAL = 0;
    private static final int TO_LOWER = 1;
    private static final int TO_UPPER = 2;
    private final List<String> mArguments = new ArrayList<String>();
    private String mSource;
    private int mCaseAction = 0;
    private String mDelimiter = ",";

    public void addArgument(String aArgument) {
        this.mArguments.add(aArgument);
    }

    private String getArgument(int aIndex) {
        CUtilCheck.checkTrue(aIndex < this.size(), "Index ({}) out of range ({}): ", aIndex, this.size());
        return this.mArguments.get(aIndex);
    }

    private String getArgument(int aIndex, String aDefault) {
        if (aIndex < this.size()) {
            return this.mArguments.get(aIndex);
        }
        return aDefault;
    }

    public String[] getArgumentArray() {
        return this.mArguments.toArray(new String[0]);
    }

    public List<String> getArgumentList() {
        return this.mArguments;
    }

    public Collection<String> getArguments() {
        return this.mArguments;
    }

    public boolean getBoolean(int aIndex) {
        String s = this.getArgument(aIndex);
        return CUtilBoolean.fromString(s);
    }

    public boolean getBoolean(int aIndex, boolean aDefault) {
        String s = this.getArgument(aIndex, null);
        return s == null ? aDefault : CUtilBoolean.fromString(s);
    }

    public long getByte(int aIndex) {
        String s = this.getArgument(aIndex);
        return CUtilByte.fromObject(s, (byte)0);
    }

    public long getByte(int aIndex, byte aDefault) {
        String s = this.getArgument(aIndex, null);
        return s == null ? (long)aDefault : (long)CUtilByte.fromObject(s, (byte)0);
    }

    public double getDouble(int aIndex) {
        String s = this.getArgument(aIndex);
        return CUtilDouble.fromString(s);
    }

    public double getDouble(int aIndex, double aDefault) {
        String s = this.getArgument(aIndex, null);
        return s == null ? aDefault : CUtilDouble.fromString(s);
    }

    public float getFloat(int aIndex) {
        String s = this.getArgument(aIndex);
        return CUtilFloat.fromString(s);
    }

    public float getFloat(int aIndex, float aDefault) {
        String s = this.getArgument(aIndex, null);
        return s == null ? aDefault : CUtilFloat.fromString(s);
    }

    public int getInt(int aIndex) {
        String s = this.getArgument(aIndex);
        return CUtilInteger.fromString(s);
    }

    public int getInt(int aIndex, int aDefault) {
        String s = this.getArgument(aIndex, null);
        return s == null ? aDefault : CUtilInteger.fromString(s);
    }

    public long getLong(int aIndex) {
        String s = this.getArgument(aIndex);
        return CUtilLong.fromString(s);
    }

    public long getLong(int aIndex, long aDefault) {
        String s = this.getArgument(aIndex, null);
        return s == null ? aDefault : CUtilLong.fromString(s);
    }

    public short getShort(int aIndex) {
        String s = this.getArgument(aIndex);
        return CUtilShort.fromString(s);
    }

    public short getShort(int aIndex, short aDefault) {
        String s = this.getArgument(aIndex, null);
        return s == null ? aDefault : CUtilShort.fromString(s);
    }

    public String getSource() {
        return this.mSource;
    }

    public String getString(int aIndex) {
        return this.getArgument(aIndex);
    }

    public String getString(int aIndex, String aDefault) {
        return this.getArgument(aIndex, aDefault);
    }

    public CStringProperty getStringProperty(int aIndex, String aDelimiter) {
        String s = this.getArgument(aIndex, null);
        if (s == null) {
            return null;
        }
        String[] result = this.split(s, aDelimiter);
        if (result.length == 0) {
            return null;
        }
        String key = result[0];
        String value = result.length > 1 ? result[1] : "";
        return new CStringProperty(key, value);
    }

    public CStringProperties parseProperties(int aStartIndex, String aDelimiter) {
        CStringProperties result = new CStringProperties();
        for (int i = aStartIndex; i < this.size(); ++i) {
            CStringProperty sp = this.getStringProperty(i, aDelimiter);
            if (sp == null) continue;
            result.put(sp);
        }
        return result;
    }

    public CArgumentList setDelimiter(String aDelimiter) {
        this.mDelimiter = aDelimiter;
        return this;
    }

    public int size() {
        return this.mArguments.size();
    }

    public CArgumentList split(@Nullable Object aSource) {
        if (aSource == null) {
            this.mSource = null;
        } else {
            this.mSource = String.valueOf(aSource);
            String[] ss = this.split(this.mSource, this.mDelimiter);
            this.mArguments.addAll(Arrays.asList(ss));
        }
        return this;
    }

    private String[] split(String[] aSource) {
        return aSource;
    }

    private String[] split(Collection<String> aSource) {
        return aSource.toArray(new String[0]);
    }

    private String[] split(String aSource, String aDelimiter) {
        if (this.mCaseAction == 1) {
            return (String[])Arrays.stream(aSource.trim().toLowerCase().split(aDelimiter)).map(String::trim).toArray(String[]::new);
        }
        if (this.mCaseAction == 2) {
            return (String[])Arrays.stream(aSource.trim().toUpperCase().split(aDelimiter)).map(String::trim).toArray(String[]::new);
        }
        return (String[])Arrays.stream(aSource.trim().split(aDelimiter)).map(String::trim).toArray(String[]::new);
    }

    public CArgumentList toLower() {
        this.mCaseAction = 1;
        return this;
    }

    public CArgumentList toOriginalCase() {
        this.mCaseAction = 0;
        return this;
    }

    public String toString() {
        return this.mSource;
    }

    public CArgumentList toUpper() {
        this.mCaseAction = 2;
        return this;
    }
}

