/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.record.helper;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.target.ITarget;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public final class CRecordHelper {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordHelper.class);
    private static final AtomicReference<INamespaceRegistry> NAMESPACE_REGISTRY = new AtomicReference<Object>(null);

    private CRecordHelper() {
    }

    public static boolean addObserver(Class<? extends IGeneratedRecord> aClass, ITarget aTarget, boolean aSendLast) throws CException {
        try {
            Field f = aClass.getDeclaredField("ID");
            IId id = (IId)f.get(null);
            f = aClass.getDeclaredField("NAMESPACES");
            String[] namespaces = (String[])f.get(null);
            INamespace ns = CRecordHelper.getNamespace(aTarget, namespaces);
            if (ns != null) {
                ns.getNanoServiceRegistry().addObserver(id, aTarget.getAddress(), aSendLast);
                return true;
            }
        }
        catch (Exception e) {
            LOG.error(e, "Invalid record class: Couldn't add observer for NanoService {}.", aClass.getName());
            throw new CException(29).append(e.getMessage());
        }
        return false;
    }

    public static INamespace getNamespace(Class<? extends IGeneratedRecord> aClass, ITarget aTarget) throws CException {
        try {
            Field f = aClass.getDeclaredField("NAMESPACES");
            String[] namespaces = (String[])f.get(null);
            return CRecordHelper.getNamespace(aTarget, namespaces);
        }
        catch (Exception e) {
            LOG.error(e, "Couldn't get namespace for NanoService {}.", aClass.getName());
            throw new CException(29).append(e.getMessage());
        }
    }

    private static INamespace getNamespace(ITarget aTarget, String[] aNamespaces) {
        IId nid = CRecordHelper.getNID(aTarget, aNamespaces);
        if (nid != null) {
            INamespaceRegistry nr = NAMESPACE_REGISTRY.get();
            if (nr == null) {
                LOG.error("Error(NamespaceRegistry is null): Register Namespace {} for Target {}", nid.toString(), aTarget.getClass().getSimpleName());
            } else {
                return nr.getNamespace(nid);
            }
        }
        return null;
    }

    public static IId getNID(Class<? extends IGeneratedRecord> aClass) throws CException {
        try {
            Field f = aClass.getDeclaredField("NAMESPACES");
            String[] namespaces = (String[])f.get(null);
            return CIdFactory.fromObject(namespaces[0]);
        }
        catch (Exception e) {
            LOG.error(e, "Couldn't get NID for NanoService {}.", aClass.getName());
            throw new CException(29).append(e.getMessage());
        }
    }

    public static IId getNID(Class<? extends IGeneratedRecord> aClass, ITarget aTarget) throws CException {
        try {
            Field f = aClass.getDeclaredField("NAMESPACES");
            String[] namespaces = (String[])f.get(null);
            return CRecordHelper.getNID(aTarget, namespaces);
        }
        catch (Exception e) {
            LOG.error(e, "Couldn't get NID for NanoService {}.", aClass.getName());
            throw new CException(29).append(e.getMessage());
        }
    }

    private static IId getNID(ITarget aTarget, String[] aNamespaces) {
        String choice;
        if (aNamespaces.length == 0) {
            return null;
        }
        if (aTarget == null) {
            choice = aNamespaces.length == 1 ? ("*".equals(aNamespaces[0]) ? CWellKnownNID.SYSTEM.toString() : aNamespaces[0]) : aNamespaces[0];
        } else if (aNamespaces.length == 1) {
            if ("*".equals(aNamespaces[0])) {
                return aTarget.getAddress().getNID();
            }
            choice = aNamespaces[0];
        } else {
            String targetNs;
            List<String> list = Arrays.asList(aNamespaces);
            if (list.contains(targetNs = aTarget.getAddress().getNID().valueToString())) {
                return aTarget.getAddress().getNID();
            }
            choice = aNamespaces[0];
        }
        return CIdFactory.fromObject(choice);
    }

    public static void init(INamespaceRegistry aNamespaceRegistry) {
        NAMESPACE_REGISTRY.set(aNamespaceRegistry);
    }

    public static boolean removeObserver(Class<? extends IGeneratedRecord> aClass, ITarget aTarget) throws CException {
        try {
            Field f = aClass.getDeclaredField("ID");
            IId id = (IId)f.get(null);
            f = aClass.getDeclaredField("NAMESPACES");
            String[] namespaces = (String[])f.get(null);
            return CRecordHelper.removeObserver(aTarget, namespaces, id);
        }
        catch (Exception e) {
            LOG.error(e, "Couldn't remove observer for NanoService {}.", aClass.getName());
            throw new CException(29).append(e.getMessage());
        }
    }

    private static boolean removeObserver(ITarget aTarget, String[] aNamespaces, IId aID) {
        if (aNamespaces == null || aNamespaces.length == 0) {
            LOG.error("Namespaces for Service {} are empty, can't remove observer for target {}", aID, aTarget.getClass().getName());
            return false;
        }
        INamespace ns = CRecordHelper.getNamespace(aTarget, aNamespaces);
        if (ns != null) {
            try {
                ns.getNanoServiceRegistry().removeObserver(aID, aTarget.getAddress());
                return true;
            }
            catch (CException e) {
                LOG.error(e, "Couldn't remove observer for NanoService {}.", aID);
            }
        }
        return false;
    }
}

