/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.job;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.job.EJobStatus;
import de.sillysky.nyssr.job.IJob;
import de.sillysky.nyssr.job.IJobThread;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.util.CUtilUuid;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public abstract class CAbstractJob
extends CTarget
implements IJob {
    private final UUID mId = CUtilUuid.random();
    private EJobStatus mStatus = EJobStatus.DETACHED;
    private IJobThread mJobThread;
    private boolean mStopped = false;
    private long mTimeStart;
    private long mTimeStop;

    @Override
    public void notifyTargetDeRegistered() {
        super.notifyTargetDeRegistered();
        this.notifyJobStopped();
    }

    @Override
    public void notifyJobStopped() {
        if (!this.mStopped) {
            this.setStatus(EJobStatus.STOPPED);
            this.mStopped = true;
            this.mTimeStop = System.currentTimeMillis();
            if (this.mJobThread != null) {
                try {
                    this.mJobThread.notifyJobFinished(this);
                }
                catch (CException aE) {
                    aE.printStackTrace();
                }
            }
        }
    }

    @Override
    @NotNull
    public UUID getId() {
        return this.mId;
    }

    @Override
    @NotNull
    public EJobStatus getStatus() {
        return this.mStatus;
    }

    @Override
    public void setStatus(@NotNull EJobStatus aStatus) {
        this.mStatus = aStatus;
    }

    @Override
    public ITarget getTarget() {
        return this;
    }

    @Override
    public void notifyJobStarted(@NotNull IJobThread aJobThread) {
        this.setStatus(EJobStatus.RUNNING);
        this.mJobThread = aJobThread;
        this.mTimeStart = System.currentTimeMillis();
    }

    @Override
    public long getMilliSecondsElapsed() {
        long time2 = Math.max(this.mTimeStop, System.currentTimeMillis());
        return time2 - this.mTimeStart;
    }

    @Override
    @NotNull
    public String getJobName() {
        return this.mId.toString();
    }
}

