/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilShort;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotShort
implements ISlot,
ISingleSlotTypeFactory {
    private final short mValue;

    CSlotShort() {
        this.mValue = 0;
    }

    private CSlotShort(short aValue) {
        this.mValue = aValue;
    }

    private CSlotShort(@Nullable Short aValue) {
        this.mValue = aValue == null ? (short)0 : aValue;
    }

    @NotNull
    private static CSlotShort fromObject(@Nullable Object aValue) {
        if (aValue instanceof Short) {
            return new CSlotShort((Short)aValue);
        }
        if (aValue instanceof String) {
            return CSlotShort.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotShort.fromList((List)aValue);
        }
        return new CSlotShort();
    }

    @NotNull
    private static CSlotShort fromList(@NotNull List<?> aValue) {
        CSlotShort result;
        if (aValue.isEmpty()) {
            result = new CSlotShort();
        } else {
            Object object = aValue.get(0);
            result = CSlotShort.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotShort fromStream(@NotNull DataInput aStream) throws IOException {
        short value = aStream.readShort();
        return new CSlotShort(value);
    }

    @NotNull
    private static CSlotShort fromString(@NotNull String aValue) {
        short value = CUtilShort.fromString(aValue);
        return new CSlotShort(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotShort.fromObject(aValue);
        }
        return null;
    }

    @Override
    @NotNull
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        short value = CUtilShort.fromObject(aValue);
        return new CSlotShort(value);
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotShort other = (CSlotShort)aObj;
        return this.mValue == other.mValue;
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return Short.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.SHORT;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Short.valueOf(this.mValue).equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotShort.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        aStream.writeShort(this.mValue);
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return Short.toString(this.mValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String valueToString() {
        return Short.toString(this.mValue);
    }

    @Override
    @NotNull
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        return (int)this.mValue;
    }
}

