/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.impl.util.CJsonRecordUtil;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.slot.ISlotFactory;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilObjectArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CSlotRecordArray
implements ISlot,
ISingleSlotTypeFactory {
    private final CRecord[] mValue;

    public CSlotRecordArray() {
        this.mValue = new CRecord[0];
    }

    private CSlotRecordArray(CRecord[] aValue) {
        this.mValue = aValue == null ? new CRecord[0] : Arrays.copyOf(aValue, aValue.length);
    }

    private CSlotRecordArray create(Object aValue) {
        CSlotRecordArray result = null;
        if (aValue == null) {
            result = new CSlotRecordArray();
        } else if (aValue instanceof CRecord[]) {
            result = new CSlotRecordArray((CRecord[])aValue);
        } else if (aValue instanceof String || aValue instanceof List) {
            // empty if block
        }
        return result;
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return this.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        ISlotFactory slotFactory;
        CJsonArray arr;
        List<Object> children;
        if (aValue instanceof CJsonArray && !(children = (arr = (CJsonArray)aValue).getChildren()).isEmpty() && (slotFactory = CServiceRegistry.getInstance().getService(ISlotFactory.class)) != null) {
            CRecord[] records = new CRecord[children.size()];
            int i = 0;
            for (Object child : children) {
                records[i] = CJsonRecordUtil.fromJson(child, aByteArrayStore, slotFactory);
                ++i;
            }
            return new CSlotRecordArray(records);
        }
        return null;
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotRecordArray other = (CSlotRecordArray)aObj;
        return Arrays.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CRecord[].class;
    }

    @Override
    @Contract(value=" -> new")
    @NotNull
    public ISlot copy() {
        CRecord[] arr = new CRecord[this.mValue.length];
        for (int i = 0; i < this.mValue.length; ++i) {
            arr[i] = new CRecord(this.mValue[i]);
        }
        return new CSlotRecordArray(arr);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.RECORD_ARRAY;
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public Object getValue() {
        if (this.mValue == null) {
            return new CRecord[0];
        }
        return Arrays.copyOf(this.mValue, this.mValue.length);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mValue);
        return result;
    }

    @Override
    public boolean isContentEqualTo(Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof CRecord[]) {
            Object[] bb = (CRecord[])aValue;
            return Arrays.equals(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (!this.getType().equals(aType)) {
            return null;
        }
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return new CSlotRecordArray();
        }
        CRecord[] arr = new CRecord[len];
        for (int i = 0; i < len; ++i) {
            arr[i] = CRecord.fromStream(aStream);
        }
        return new CSlotRecordArray(arr);
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CPositiveInteger.toStream(aStream, this.mValue.length);
        for (CRecord element : this.mValue) {
            element.toStream(aStream);
        }
    }

    public String toString() {
        return CUtilObjectArray.toString((Object[])this.mValue, 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (CRecord value : this.mValue) {
                if (value != null) {
                    CJsonObject json = CJsonRecordUtil.toJson(value, aBinaries);
                    arr.add(json);
                    continue;
                }
                arr.add("");
            }
            return arr;
        }
        return null;
    }
}

