/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CUtilNodeIdArray;
import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilObjectArray;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotNodeIdArray
implements ISlot,
ISingleSlotTypeFactory {
    private final CNodeId[] mValue;

    CSlotNodeIdArray() {
        this.mValue = null;
    }

    private CSlotNodeIdArray(CNodeId @Nullable [] aValue) {
        this.mValue = CUtilNodeIdArray.copy(aValue);
    }

    @NotNull
    private static CSlotNodeIdArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof CNodeId[]) {
            return new CSlotNodeIdArray((CNodeId[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotNodeIdArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotNodeIdArray.fromList((List)aValue);
        }
        return new CSlotNodeIdArray();
    }

    @NotNull
    private static CSlotNodeIdArray fromList(@NotNull List<?> aList) {
        CNodeId[] array = CUtilNodeIdArray.fromList(aList);
        return new CSlotNodeIdArray(array);
    }

    @NotNull
    private static CSlotNodeIdArray fromStream(@NotNull DataInput aStream) throws IOException {
        CNodeId[] array = CUtilNodeIdArray.fromStream(aStream);
        return new CSlotNodeIdArray(array);
    }

    @NotNull
    private static CSlotNodeIdArray fromString(@NotNull String aString) {
        CNodeId[] array = CUtilNodeIdArray.fromString(aString);
        return new CSlotNodeIdArray(array);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotNodeIdArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            CNodeId[] values = new CNodeId[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String && CUtilString.isValid((String)child)) {
                    String s = (String)child;
                    values[i] = CNodeId.fromObject(s);
                } else {
                    values[i] = null;
                }
                ++i;
            }
            return new CSlotNodeIdArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotNodeIdArray other = (CSlotNodeIdArray)aObj;
        return CUtilNodeIdArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CNodeId[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return new CSlotNodeIdArray(this.mValue);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.NODE_ID_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof CNodeId[]) {
            CNodeId[] bb = (CNodeId[])aValue;
            return CUtilNodeIdArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotNodeIdArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilNodeIdArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilObjectArray.toString((Object[])this.mValue, 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilNodeIdArray.toString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (CNodeId id : this.mValue) {
                arr.add(id == null ? "" : id.valueToString());
            }
            return arr;
        }
        return null;
    }
}

