/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonHash;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilStringArray;
import de.sillysky.nyssr.util.hash.CHashFactory;
import de.sillysky.nyssr.util.hash.IDigest;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotHashArray
implements ISlot,
ISingleSlotTypeFactory {
    @NotNull
    private final IDigest[] mValue;

    CSlotHashArray() {
        this.mValue = new IDigest[0];
    }

    private CSlotHashArray(IDigest[] aValue) {
        this.mValue = CSlotHashArray.copy(aValue);
    }

    @NotNull
    private static CSlotHashArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof IDigest[]) {
            return new CSlotHashArray((IDigest[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotHashArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotHashArray.fromList((List)aValue);
        }
        return new CSlotHashArray();
    }

    @NotNull
    private static CSlotHashArray fromList(@NotNull List<?> aValue) {
        if (aValue.isEmpty()) {
            return new CSlotHashArray();
        }
        ArrayList<IDigest> list = new ArrayList<IDigest>();
        for (Object element : aValue) {
            String s;
            IDigest ta;
            if (element == null) continue;
            if (element instanceof IDigest) {
                IDigest e = (IDigest)element;
                list.add(e);
                continue;
            }
            if (element instanceof IDigest[]) {
                IDigest[] ee = (IDigest[])element;
                Collections.addAll(list, ee);
                continue;
            }
            if (!(element instanceof String) || (ta = CHashFactory.fromString(s = (String)element)) == null) continue;
            list.add(ta);
        }
        IDigest[] arr = new IDigest[list.size()];
        int pos = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IDigest element;
            arr[pos] = element = (IDigest)iterator.next();
            ++pos;
        }
        return new CSlotHashArray(arr);
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotHashArray fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len < 0) {
            len = 0;
        }
        IDigest[] value = new IDigest[len];
        for (int i = 0; i < len; ++i) {
            value[i] = CHashFactory.fromStream(aStream);
        }
        return new CSlotHashArray(value);
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotHashArray fromString(@NotNull String aValue) {
        String[] result = CUtilStringArray.fromString(aValue);
        if (result == null || result.length == 0) {
            return new CSlotHashArray();
        }
        IDigest[] value = new IDigest[result.length];
        for (int i = 0; i < result.length; ++i) {
            value[i] = CHashFactory.fromString(result[i]);
        }
        return new CSlotHashArray(value);
    }

    @NotNull
    private static @NotNull IDigest @NotNull [] copy(@Nullable IDigest[] aValue) {
        ArrayList<IDigest> list = new ArrayList<IDigest>(Arrays.asList(aValue));
        if (list.isEmpty()) {
            return new IDigest[0];
        }
        return list.toArray(new IDigest[0]);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotHashArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            IDigest[] values = new IDigest[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                values[i++] = CUtilJsonHash.fromJson(child, aByteArrayStore);
            }
            return new CSlotHashArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotHashArray other = (CSlotHashArray)aObj;
        return Arrays.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return IDigest[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.HASH_ARRAY;
    }

    @Override
    @NotNull
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return this.mValue.equals(aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotHashArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CPositiveInteger.toStream(aStream, this.mValue.length);
        for (IDigest element : this.mValue) {
            element.toStream(aStream);
        }
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.mValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String valueToString() {
        return Arrays.toString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (IDigest i : this.mValue) {
                Object o = CUtilJsonHash.toJson(i, aBinaries);
                arr.add(o == null ? Boolean.FALSE : o);
            }
            return arr;
        }
        return null;
    }
}

