/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilByteArray;
import de.sillysky.nyssr.util.CUtilInteger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotByteArray
implements ISlot,
ISingleSlotTypeFactory {
    private final byte[] mValue;

    CSlotByteArray() {
        this.mValue = null;
    }

    private CSlotByteArray(byte[] aValue) {
        this.mValue = CUtilByteArray.copy(aValue);
    }

    @NotNull
    private static CSlotByteArray fromObject(@Nullable Object aValue) {
        if (aValue instanceof byte[]) {
            return CSlotByteArray.fromValue((byte[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotByteArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotByteArray.fromList((List)aValue);
        }
        return new CSlotByteArray();
    }

    @NotNull
    private static CSlotByteArray fromList(@NotNull List<?> aValue) {
        byte[] arr = CUtilByteArray.fromList(aValue);
        return new CSlotByteArray(arr);
    }

    @NotNull
    private static CSlotByteArray fromStream(@NotNull DataInput aStream) throws IOException {
        byte[] value = CUtilByteArray.fromStream(aStream);
        return new CSlotByteArray(value);
    }

    @NotNull
    private static CSlotByteArray fromString(@NotNull String aValue) {
        byte[] value = CUtilByteArray.fromString(aValue);
        return new CSlotByteArray(value);
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotByteArray fromValue(byte[] aValue) {
        byte[] value = CUtilByteArray.copy(aValue);
        return new CSlotByteArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotByteArray.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        byte[] bb;
        int hash = CUtilInteger.fromObject(aValue, 0);
        if (hash != 0 && (bb = aByteArrayStore.get(hash)) != null) {
            return new CSlotByteArray(bb);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotByteArray other = (CSlotByteArray)aObj;
        return CUtilByteArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return byte[].class;
    }

    @Override
    public ISlot copy() {
        byte[] copy = CUtilByteArray.copy(this.mValue);
        return new CSlotByteArray(copy);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.BYTE_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof byte[]) {
            byte[] bb = (byte[])aValue;
            return CUtilByteArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotByteArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilByteArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilByteArray.toString(this.mValue, ',', 1000);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilByteArray.toString(this.mValue, ',', 0);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            int i = Objects.hashCode(this.mValue);
            aBinaries.put(i, this.mValue);
            return i;
        }
        return null;
    }
}

