/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CBitField;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotBitField
implements ISlot,
ISingleSlotTypeFactory {
    private final CBitField mValue;

    CSlotBitField() {
        this.mValue = new CBitField();
    }

    private CSlotBitField(@Nullable CBitField aValue) {
        this.mValue = aValue;
    }

    private static CSlotBitField create(Object aValue) {
        CSlotBitField result = null;
        if (aValue == null) {
            result = new CSlotBitField();
        } else if (aValue instanceof CBitField) {
            result = new CSlotBitField((CBitField)aValue);
        } else if (aValue instanceof Integer) {
            CBitField bf = new CBitField((Integer)aValue);
            result = new CSlotBitField(bf);
        } else if (aValue instanceof Short) {
            CBitField bf = new CBitField((Integer)aValue);
            result = new CSlotBitField(bf);
        } else if (aValue instanceof Long) {
            CBitField bf = new CBitField((Integer)aValue);
            result = new CSlotBitField(bf);
        } else if (aValue instanceof Byte) {
            CBitField bf = new CBitField((Byte)aValue);
            result = new CSlotBitField(bf);
        } else if (aValue instanceof byte[]) {
            CBitField bf = new CBitField((byte[])aValue);
            result = new CSlotBitField(bf);
        } else if (aValue instanceof String) {
            result = CSlotBitField.fromString((String)aValue);
        } else if (aValue instanceof List) {
            result = CSlotBitField.fromList((List)aValue);
        }
        return result;
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotBitField fromList(List<?> aValue) {
        CBitField bf;
        try {
            bf = CBitField.fromList(aValue);
        }
        catch (CException e) {
            bf = null;
        }
        return new CSlotBitField(bf);
    }

    @NotNull
    private static CSlotBitField fromStream(@NotNull DataInput aStream) throws IOException {
        CBitField bf = CBitField.fromStreamVariableLength(aStream);
        return new CSlotBitField(bf);
    }

    @Contract(value="_ -> new")
    @NotNull
    private static CSlotBitField fromString(@NotNull String aValue) {
        CBitField bf;
        try {
            bf = CBitField.fromString(aValue);
        }
        catch (CException e) {
            bf = null;
        }
        return new CSlotBitField(bf);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotBitField.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            byte[] bytes = CUtilBase64.decode((String)aValue);
            CBitField bf = new CBitField(bytes);
            return new CSlotBitField(bf);
        }
        return null;
    }

    @Override
    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotBitField other = (CSlotBitField)aObj;
        return CBitField.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return CBitField.class;
    }

    @Override
    @Nullable
    public ISlot copy() {
        if (this.mValue == null) {
            return null;
        }
        CBitField bf = this.mValue.getCopy();
        return new CSlotBitField(bf);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.BIT_FIELD;
    }

    @Override
    public CBitField getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        if (this.mValue != null) {
            result = 31 * result + this.mValue.hashCode();
        }
        return result;
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null) {
            return this.mValue.equals(aValue);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotBitField.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CBitField.toStreamVariableLength(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        if (this.mValue == null) {
            return "null";
        }
        return this.mValue.toString();
    }

    @Override
    @NotNull
    public String valueToString() {
        if (this.mValue == null) {
            return "";
        }
        return this.mValue.valueToString();
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        byte[] bytes;
        if (this.mValue != null && (bytes = this.mValue.getBytes()) != null && bytes.length > 0) {
            return CUtilBase64.encodeToString(bytes);
        }
        return null;
    }
}

