/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.signal.properties;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.signal.properties.IPropertySignal;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

final class CPropertySignal
implements IPropertySignal {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPropertySignal.class);
    private final UUID mID;
    private final Map<String, Object> mProperties = new HashMap<String, Object>();
    private final long mTime = System.nanoTime();
    private IPropertySignalDispatcher mDispatcher;

    CPropertySignal(UUID aID) {
        this.mID = aID;
    }

    @Override
    public boolean getBoolean(String aKey, boolean aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            this.log(Boolean.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public byte getByte(String aKey, byte aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof Byte) {
                return (Byte)value;
            }
            this.log(Byte.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public byte[] getByteArray(String aKey, byte[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            this.log(byte[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public char getCharacter(String aKey, char aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof Character) {
                return ((Character)value).charValue();
            }
            this.log(Character.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public char[] getCharacterArray(String aKey, char[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof char[]) {
                return (char[])value;
            }
            this.log(char[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public IId getID(String aKey, IId aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof IId) {
                return (IId)value;
            }
            this.log(IId.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public IId[] getIDArray(String aKey, IId[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof IId[]) {
                return (IId[])value;
            }
            this.log(IId[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public int getInt(String aKey, int aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            this.log(Integer.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public int[] getIntArray(String aKey, int[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof int[]) {
                return (int[])value;
            }
            this.log(int[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public long getLong(String aKey, long aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof Long) {
                return (Long)value;
            }
            this.log(Long.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public long[] getLongArray(String aKey, long[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof long[]) {
                return (long[])value;
            }
            this.log(long[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public CNodeAddress getNodeAddress(String aKey, CNodeAddress aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof CNodeAddress) {
                return (CNodeAddress)value;
            }
            this.log(CNodeAddress.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public CNodeId getNodeId(String aKey, CNodeId aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof CNodeId) {
                return (CNodeId)value;
            }
            this.log(CNodeId.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public CNodeId[] getNodeIdArray(String aKey, CNodeId[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof CNodeId[]) {
                return (CNodeId[])value;
            }
            this.log(CNodeId[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public Object getObject(String aKey, Object aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            return value;
        }
        return aDefault;
    }

    @Override
    public short getShort(String aKey, short aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof Short) {
                return (Short)value;
            }
            this.log(Short.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public short[] getShortArray(String aKey, short[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof short[]) {
                return (short[])value;
            }
            this.log(short[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public UUID getSignalID() {
        return this.mID;
    }

    @Override
    public IPropertySignalDispatcher getSource() {
        return this.mDispatcher;
    }

    @Override
    public String getString(String aKey, String aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof String) {
                return (String)value;
            }
            this.log(String.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public String[] getStringArray(String aKey, String[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof String[]) {
                return (String[])value;
            }
            this.log(String[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public CTargetAddress getTargetAddress(String aKey, CTargetAddress aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof CTargetAddress) {
                return (CTargetAddress)value;
            }
            this.log(CTargetAddress.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public CTargetAddress[] getTargetAddressArray(String aKey, CTargetAddress[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof CTargetAddress[]) {
                return (CTargetAddress[])value;
            }
            this.log(CTargetAddress[].class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public long getTime() {
        return this.mTime;
    }

    @Override
    public UUID getUuid(String aKey, UUID aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof UUID) {
                return (UUID)value;
            }
            this.log(UUID.class, value, aKey);
        }
        return aDefault;
    }

    @Override
    public UUID[] getUuidArray(String aKey, UUID[] aDefault) {
        Object value = this.mProperties.get(aKey);
        if (value != null) {
            if (value instanceof UUID[]) {
                return (UUID[])value;
            }
            this.log(UUID[].class, value, aKey);
        }
        return aDefault;
    }

    private void log(Class<?> aClass, Object aValue, String aKey) {
        LOG.error("Wrong Signal data type: expected: {}, found: {}, ID: {}, Key: {}", aClass.getName(), aValue.getClass().getName(), this.mID, aKey);
    }

    @Override
    public void set(String aKey, Object aValue) {
        this.mProperties.put(aKey, aValue);
    }

    @Override
    public void setSource(IPropertySignalDispatcher aSource) {
        this.mDispatcher = aSource;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ID=");
        sb.append(this.mID);
        sb.append(" {");
        int i = 0;
        for (Map.Entry<String, Object> e : this.mProperties.entrySet()) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(e.getKey());
            sb.append("=");
            sb.append(e.getValue());
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

