/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.preferences;

import de.sillysky.nyssr.impl.preferences.CBackingStoreException;
import de.sillysky.nyssr.impl.preferences.CChangeSet;
import de.sillysky.nyssr.impl.preferences.CPreferencesDescription;
import de.sillysky.nyssr.impl.preferences.IBackingStoreManager;
import de.sillysky.nyssr.preferences.IPreferences;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class CPreferences
implements IPreferences {
    private static final int SIX = 6;
    private static final int EIGHT = 8;
    private final Map<String, String> mProperties = new HashMap<String, String>();
    private final CPreferences mParent;
    private final Map<String, CPreferences> mChildren = new HashMap<String, CPreferences>();
    private final String mName;
    private final CPreferencesDescription mDescription;
    private final IBackingStoreManager mStoreManager;
    private final CChangeSet mChangeSet = new CChangeSet();
    private boolean mValid = true;

    private CPreferences(CPreferences aPreferences, String aName) {
        this.mParent = aPreferences;
        this.mName = aName;
        this.mDescription = aPreferences.mDescription;
        this.mStoreManager = aPreferences.mStoreManager;
    }

    CPreferences(CPreferencesDescription aDescription, IBackingStoreManager aStoreManager) {
        this.mParent = null;
        this.mName = "";
        this.mDescription = aDescription;
        this.mStoreManager = aStoreManager;
    }

    @Override
    public String absolutePath() {
        if (this.mParent == null) {
            return "/";
        }
        String parentPath = this.mParent.absolutePath();
        if (parentPath.length() == 1) {
            return parentPath + this.mName;
        }
        return parentPath + '/' + this.mName;
    }

    void applyChanges(CPreferences aPreferences) {
        CChangeSet changeSet = aPreferences.getChangeSet();
        if (changeSet.hasChanges()) {
            this.mChangeSet.importChanges(aPreferences.mChangeSet);
            Iterator<String> i = changeSet.getRemovedProperties().iterator();
            while (i.hasNext()) {
                this.mProperties.remove(i.next());
            }
            for (String key : changeSet.getChangedProperties()) {
                this.mProperties.put(key, aPreferences.mProperties.get(key));
            }
            for (String name : changeSet.getRemovedChildren()) {
                this.mChildren.remove(name);
            }
        }
        for (CPreferences current : aPreferences.getChildren()) {
            CPreferences child = this.getOrCreateNode(current.name());
            child.applyChanges(current);
        }
    }

    private void checkKey(String aKey) throws NullPointerException {
        if (aKey == null) {
            throw new NullPointerException("Key must not be null.");
        }
    }

    private void checkValidity() throws IllegalStateException {
        if (!this.mValid) {
            throw new IllegalStateException("The preferences node has been removed.");
        }
    }

    private void checkValue(Object aValue) throws NullPointerException {
        if (aValue == null) {
            throw new NullPointerException("Value must not be null.");
        }
    }

    @Override
    public synchronized String[] childrenNames() throws CBackingStoreException {
        if (!this.mChangeSet.hasChanges()) {
            this.mStoreManager.getStore().update(this);
        }
        Set<String> names = this.mChildren.keySet();
        return names.toArray(new String[0]);
    }

    @Override
    public synchronized void clear() {
        this.checkValidity();
        for (String key : this.mProperties.keySet()) {
            this.mChangeSet.propertyRemoved(key);
        }
        this.mProperties.clear();
    }

    @Override
    public synchronized void flush() throws CBackingStoreException {
        this.checkValidity();
        this.mStoreManager.getStore().store(this);
        this.mChangeSet.clear();
    }

    @Override
    public synchronized String get(String aKey, String aDefault) {
        if (aKey == null) {
            throw new NullPointerException();
        }
        this.checkValidity();
        String value = this.mProperties.get(aKey);
        if (value == null) {
            value = aDefault;
        }
        return value;
    }

    IBackingStoreManager getBackingStoreManager() {
        return this.mStoreManager;
    }

    @Override
    public boolean getBoolean(String aKey, boolean aDefault) {
        boolean result = aDefault;
        String value = this.get(aKey, null);
        if (value != null) {
            if (value.equalsIgnoreCase("true")) {
                result = true;
            } else if (value.equalsIgnoreCase("false")) {
                result = false;
            }
        }
        return result;
    }

    @Override
    public byte[] getByteArray(String aKey, byte[] aDefault) {
        byte[] result = aDefault;
        String value = this.get(aKey, null);
        if (value != null) {
            boolean valid;
            byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
            boolean bl = valid = bytes.length * 6 % 8 == 0;
            if (valid) {
                for (int i = 0; i < bytes.length - 1; ++i) {
                    byte b = bytes[i];
                    if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 43 || b == 47) continue;
                    valid = false;
                    break;
                }
            }
            if (valid) {
                result = Base64.getDecoder().decode(value.getBytes(StandardCharsets.UTF_8));
            }
        }
        return result;
    }

    CChangeSet getChangeSet() {
        return this.mChangeSet;
    }

    Collection<CPreferences> getChildren() {
        return this.mChildren.values();
    }

    CPreferencesDescription getDescription() {
        return this.mDescription;
    }

    @Override
    public double getDouble(String aKey, double aDefault) {
        double result = aDefault;
        String value = this.get(aKey, null);
        if (value != null) {
            try {
                result = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public float getFloat(String aKey, float aDefault) {
        float result = aDefault;
        String value = this.get(aKey, null);
        if (value != null) {
            try {
                result = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public int getInt(String aKey, int aDefault) {
        int result = aDefault;
        String value = this.get(aKey, null);
        if (value != null) {
            try {
                result = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public long getLong(String aKey, long aDefault) {
        long result = aDefault;
        String value = this.get(aKey, null);
        if (value != null) {
            try {
                result = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CPreferences getNode(String aPath, boolean aSaveNewlyCreatedNode, boolean aCreate) {
        String path = aPath;
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Path must not contained consecutive slashes");
        }
        if (path.endsWith("/")) {
            throw new IllegalArgumentException("Path must not contained trailing slashes");
        }
        if (path.length() == 0) {
            return this;
        }
        CPreferences cPreferences = this;
        synchronized (cPreferences) {
            this.checkValidity();
            String subPath = null;
            int pos = path.indexOf(47);
            if (pos != -1) {
                subPath = path.substring(pos + 1);
                path = path.substring(0, pos);
            }
            boolean save = false;
            CPreferences child = this.mChildren.get(path);
            if (child == null) {
                if (!aCreate) {
                    return null;
                }
                child = new CPreferences(this, path);
                this.mChildren.put(path, child);
                this.mChangeSet.childAdded(path);
                if (aSaveNewlyCreatedNode) {
                    save = true;
                }
            }
            CPreferences result = subPath == null ? child : child.getNode(subPath, aSaveNewlyCreatedNode, aCreate);
            if (save) {
                try {
                    assert (result != null);
                    result.flush();
                }
                catch (CBackingStoreException cBackingStoreException) {
                    // empty catch block
                }
            }
            return result;
        }
    }

    CPreferences getOrCreateNode(String aPathName) {
        String path = aPathName;
        if (path == null) {
            throw new NullPointerException("Path must not be null.");
        }
        CPreferences executingNode = this;
        if (path.length() == 0) {
            return this;
        }
        if (path.startsWith("/") && this.mParent != null) {
            executingNode = this.getRoot();
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return executingNode.getNode(path, false, true);
    }

    Map<String, String> getProperties() {
        return this.mProperties;
    }

    CPreferences getRoot() {
        CPreferences root = this;
        while (root.mParent != null) {
            root = root.mParent;
        }
        return root;
    }

    synchronized boolean isValid() {
        return this.mValid;
    }

    @Override
    public synchronized String[] keys() throws CBackingStoreException {
        if (!this.mChangeSet.hasChanges()) {
            this.mStoreManager.getStore().update(this);
        }
        Set<String> keys = this.mProperties.keySet();
        return keys.toArray(new String[0]);
    }

    @Override
    public String name() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPreferences node(String aPathName) {
        String path = aPathName;
        if (path == null) {
            throw new NullPointerException("Path must not be null.");
        }
        CPreferences executingNode = this;
        CPreferences cPreferences = this;
        synchronized (cPreferences) {
            this.checkValidity();
            if (path.length() == 0) {
                return this;
            }
            if (path.startsWith("/") && this.mParent != null) {
                executingNode = this.getRoot();
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        return executingNode.getNode(path, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean nodeExists(String aPathName) {
        String path = aPathName;
        if (path == null) {
            throw new NullPointerException("Path must not be null.");
        }
        if (path.length() == 0) {
            return this.mValid;
        }
        CPreferences node = this;
        CPreferences cPreferences = this;
        synchronized (cPreferences) {
            this.checkValidity();
            if (path.startsWith("/") && this.mParent != null) {
                node = this.getRoot();
            }
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
        }
        CPreferences searchNode = node.getNode(path, false, false);
        return searchNode != null;
    }

    @Override
    public IPreferences parent() {
        this.checkValidity();
        return this.mParent;
    }

    @Override
    public synchronized void put(String aKey, String aValue) {
        this.checkKey(aKey);
        this.checkValue(aValue);
        this.checkValidity();
        this.mProperties.put(aKey, aValue);
        this.mChangeSet.propertyChanged(aKey);
    }

    @Override
    public void putBoolean(String aKey, boolean aValue) {
        this.put(aKey, String.valueOf(aValue));
    }

    @Override
    public void putByteArray(String aKey, byte[] aValue) {
        this.checkKey(aKey);
        this.checkValue(aValue);
        this.put(aKey, Base64.getEncoder().encodeToString(aValue));
    }

    @Override
    public void putDouble(String aKey, double aValue) {
        this.put(aKey, String.valueOf(aValue));
    }

    @Override
    public void putFloat(String aKey, float aValue) {
        this.put(aKey, String.valueOf(aValue));
    }

    @Override
    public void putInt(String aKey, int aValue) {
        this.put(aKey, String.valueOf(aValue));
    }

    @Override
    public void putLong(String aKey, long aValue) {
        this.put(aKey, String.valueOf(aValue));
    }

    @Override
    public synchronized void remove(String aKey) {
        this.checkKey(aKey);
        this.checkValidity();
        this.mProperties.remove(aKey);
        this.mChangeSet.propertyRemoved(aKey);
    }

    private synchronized void removeChild(CPreferences aChild) {
        this.mChildren.remove(aChild.name());
        this.mChangeSet.childRemoved(aChild.name());
    }

    @Override
    public void removeNode() {
        this.checkValidity();
        this.safelyRemoveNode();
        if (this.mParent != null) {
            this.mParent.removeChild(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safelyRemoveNode() {
        if (this.mValid) {
            ArrayList<CPreferences> c;
            CPreferences cPreferences = this;
            synchronized (cPreferences) {
                this.mValid = false;
                this.mProperties.clear();
                c = new ArrayList<CPreferences>(this.mChildren.values());
                this.mChildren.clear();
            }
            for (CPreferences child : c) {
                child.safelyRemoveNode();
            }
        }
    }

    @Override
    public synchronized void sync() throws CBackingStoreException {
        this.checkValidity();
        this.mStoreManager.getStore().update(this);
        this.mStoreManager.getStore().store(this);
    }

    void update(CPreferences aImpl) {
        for (Map.Entry<String, String> entry : aImpl.mProperties.entrySet()) {
            if (this.mProperties.containsKey(entry.getKey())) continue;
            this.mProperties.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : aImpl.mChildren.entrySet()) {
            String name = entry.getKey();
            CPreferences child = (CPreferences)entry.getValue();
            if (!this.mChildren.containsKey(name)) {
                this.node(name);
            }
            this.mChildren.get(name).update(child);
        }
    }
}

