/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.preferences;

import de.sillysky.nyssr.impl.preferences.CBackingStoreManager;
import de.sillysky.nyssr.impl.preferences.CPreferenceServiceFactory;
import de.sillysky.nyssr.impl.preferences.IBackingStoreManager;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.preferences.IPreferenceServiceFactory;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public final class CPackagePreferences
implements IServiceStarter {
    private static IBackingStoreManager mStoreManager;
    private static IPreferenceServiceFactory mPreferenceServiceFactory;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(IKernelConfiguration.class);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) {
        if (mStoreManager == null) {
            IKernelConfiguration kernelConfiguration = aServiceRegistry.getService(IKernelConfiguration.class);
            mStoreManager = new CBackingStoreManager(kernelConfiguration);
            if (mPreferenceServiceFactory == null) {
                mPreferenceServiceFactory = new CPreferenceServiceFactory(mStoreManager);
                aServiceRegistry.registerService(IPreferenceServiceFactory.class, mPreferenceServiceFactory);
            }
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) {
        if (mStoreManager != null) {
            mStoreManager = null;
        }
        if (mPreferenceServiceFactory != null) {
            aServiceRegistry.deregisterServiceType(IPreferenceServiceFactory.class);
            mPreferenceServiceFactory = null;
        }
    }
}

