/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.plugin;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.plugin.IPlugInEntry;
import de.sillysky.nyssr.plugin.records.CRecordPlugIn;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilPath;
import de.sillysky.nyssr.util.version.CVersion;
import java.io.File;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public final class CPlugInEntry
implements Comparable<CPlugInEntry>,
IPlugInEntry {
    private final String mPath;
    private final String mName;
    private long mStartTime = 0L;
    private CResult mError = null;
    private String mClassName = null;
    private URL mJarUrl;

    public CPlugInEntry(CRecord aRecord) {
        this.mPath = CRecordPlugIn.getPath(aRecord, "");
        this.mName = CRecordPlugIn.getName(aRecord, "");
        this.mClassName = CRecordPlugIn.getClass(aRecord, "");
        boolean loaded = CRecordPlugIn.getLoaded(aRecord, false);
        if (!loaded) {
            int code = CRecordPlugIn.getErrorCode(aRecord, 0);
            String message = CRecordPlugIn.getErrorMessage(aRecord, "");
            if (code != 0) {
                this.mError = new CResult(code, message);
            }
        }
        CRecordPlugIn.getStartTime(aRecord, 0L);
    }

    CPlugInEntry(File aFile) {
        this.mPath = aFile.getPath();
        this.mName = aFile.getName();
    }

    @Override
    public int compareTo(CPlugInEntry aOther) {
        return Long.compare(this.mStartTime, aOther.mStartTime);
    }

    public CRecord createRecord() throws CException {
        CRecord rec = CRecordPlugIn.create();
        this.fillRecord(rec);
        return rec;
    }

    public boolean equals(Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (!(aObj instanceof CPlugInEntry)) {
            return false;
        }
        CPlugInEntry other = (CPlugInEntry)aObj;
        if (this.mPath == null) {
            return other.mPath == null;
        }
        return this.mPath.equals(other.mPath);
    }

    private void fillRecord(CRecord aRecord) throws CException {
        CRecordPlugIn.setPath(aRecord, this.mPath);
        CRecordPlugIn.setName(aRecord, this.mName);
        if (this.mError != null) {
            CRecordPlugIn.setErrorCode(aRecord, this.mError.getCode());
            CRecordPlugIn.setErrorMessage(aRecord, this.mError.getText());
            CRecordPlugIn.setLoaded(aRecord, false);
        } else {
            CRecordPlugIn.setLoaded(aRecord, true);
            CRecordPlugIn.setStartTime(aRecord, this.mStartTime);
            if (CUtilString.isValid(this.mClassName)) {
                CRecordPlugIn.setClass(aRecord, this.mClassName);
            }
        }
    }

    public URL getJarUrl() {
        return this.mJarUrl;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    @Override
    public String getPlugInClassName() {
        return this.mClassName;
    }

    @Override
    public CResult getResult() {
        return this.mError;
    }

    @Override
    public long getStartTime() {
        return this.mStartTime;
    }

    @Override
    @NotNull
    public CVersion getVersion() {
        String temp = CUtilPath.stripExtension(this.mName);
        CVersion v = CVersion.fromFilename(temp);
        v.setData(this);
        return v;
    }

    @Override
    public boolean hasSuccess() {
        return this.mError == null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mPath == null ? 0 : this.mPath.hashCode());
        return result;
    }

    void setPlugInClass(@NotNull Class<?> aClass) {
        this.mClassName = aClass.getName();
    }

    void setStartResult(long aStartTime, CResult aResult) {
        this.mStartTime = aStartTime;
        this.mError = aResult == null || aResult.getCode() == 0 ? null : aResult;
    }

    void setURL(URL aUrl) {
        this.mJarUrl = aUrl;
    }

    public String toString() {
        return this.mName;
    }
}

