/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namespace.monitor;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.id.common.CWellKnownTID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.namespace.monitor.IPrivateNamespaceMonitor;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.IMessageSender;
import de.sillysky.nyssr.namespace.monitor.INamespaceMonitor;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.records.CRecordNamespaceMonitorNotifyNamespaceDeregistered;
import de.sillysky.nyssr.records.CRecordNamespaceMonitorNotifyNamespaceRegistered;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.listener.IListenerRegistry;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class CNamespaceMonitor
implements IService,
INamespaceMonitor,
IPrivateNamespaceMonitor {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNamespaceMonitor.class);
    private final UUID REQUESTER_ID = UUID.randomUUID();
    private final Map<CTargetAddress, Set<IId>> mObservers = new HashMap<CTargetAddress, Set<IId>>(10);
    private IMessageSender mMessageSender;
    private IListenerRegistry mListenerRegistry;
    private CTargetAddress mMyAddress;

    private static boolean privateFilterIDs(IId aTrigger, IId aFilter) {
        if (aFilter == null || IId.INVALID.equals(aFilter) || CWellKnownNID.ALL.equals(aFilter)) {
            return true;
        }
        return CIdFactory.equals(aFilter, aTrigger);
    }

    private static boolean privateFilterOneObserver(IId aTrigger, Collection<IId> aFilter) {
        for (IId filter : aFilter) {
            if (!CNamespaceMonitor.privateFilterIDs(aTrigger, filter)) continue;
            return true;
        }
        return false;
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IMessageSender.class);
        aDependencyList.add(IListenerRegistry.class);
    }

    @Override
    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.debug("Activate {}", this.getClass().getSimpleName());
        this.mMessageSender = aServiceRegistry.getService(IMessageSender.class);
        assert (this.mMessageSender != null);
        this.mMyAddress = new CTargetAddress(CWellKnownTID.NAMESPACE_MONITOR, CWellKnownNID.SYSTEM, this.mMessageSender.getNodeAddress());
        this.mListenerRegistry = aServiceRegistry.getService(IListenerRegistry.class);
        aServiceRegistry.registerService(INamespaceMonitor.class, this);
        aServiceRegistry.registerService(IPrivateNamespaceMonitor.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFilter(CTargetAddress aObserver, IId aNID) {
        boolean exist = this.mListenerRegistry.hasAddress(this.REQUESTER_ID, aObserver);
        if (!exist) {
            this.mListenerRegistry.addAddress(this.REQUESTER_ID, aObserver);
        }
        Map<CTargetAddress, Set<IId>> map = this.mObservers;
        synchronized (map) {
            Set set = this.mObservers.computeIfAbsent(aObserver, k -> new HashSet());
            if (!set.contains(aNID)) {
                LOG.debug("Add namespace monitor for {}:", aNID);
                set.add(aNID);
            }
        }
    }

    @Override
    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mListenerRegistry.clear(this.REQUESTER_ID);
        aServiceRegistry.deregisterService(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privateFilterObservers(IId aTrigger, Collection<CTargetAddress> aToFill) {
        Map<CTargetAddress, Set<IId>> map = this.mObservers;
        synchronized (map) {
            this.privateUpdate();
            for (Map.Entry<CTargetAddress, Set<IId>> o : this.mObservers.entrySet()) {
                CTargetAddress key = o.getKey();
                Set<IId> value = o.getValue();
                if (!CNamespaceMonitor.privateFilterOneObserver(aTrigger, value)) continue;
                aToFill.add(key);
            }
        }
    }

    private Set<IId> privateGetObserver(CTargetAddress aObserver, boolean aAdd) {
        Set<IId> result = this.mObservers.get(aObserver);
        if (result == null && aAdd) {
            result = new HashSet<IId>();
            LOG.debug("Add namespace monitor observer {}:", aObserver);
            this.mObservers.put(aObserver, result);
        }
        return result;
    }

    private void privateUpdate() {
        this.mObservers.entrySet().removeIf(e -> !this.mListenerRegistry.hasAddress(this.REQUESTER_ID, (CTargetAddress)e.getKey()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFilter(CTargetAddress aObserver, IId aNID) {
        Map<CTargetAddress, Set<IId>> map = this.mObservers;
        synchronized (map) {
            Set<IId> set = this.privateGetObserver(aObserver, false);
            if (set != null && set.contains(aNID)) {
                LOG.debug("Remove namespace monitor for {}:", aNID);
                set.remove(aNID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeObserver(CTargetAddress aObserver) {
        this.mListenerRegistry.removeAddress(this.REQUESTER_ID, aObserver);
        Map<CTargetAddress, Set<IId>> map = this.mObservers;
        synchronized (map) {
            Set<IId> set = this.privateGetObserver(aObserver, false);
            if (set != null) {
                Iterator<IId> it = set.iterator();
                while (it.hasNext()) {
                    IId o = it.next();
                    LOG.debug("Remove namespace monitor for {}:", o);
                    it.remove();
                }
            }
        }
    }

    @Override
    public void triggerNamespaceDeregistered(IId aNID) throws CException {
        HashSet<CTargetAddress> observers = new HashSet<CTargetAddress>();
        this.privateFilterObservers(aNID, observers);
        for (CTargetAddress a : observers) {
            CEnvelope env = CEnvelope.forSingleTarget(a);
            env.setSender(this.mMyAddress);
            CRecord rec = CRecordNamespaceMonitorNotifyNamespaceDeregistered.create();
            CRecordNamespaceMonitorNotifyNamespaceDeregistered.setNid(rec, aNID);
            this.mMessageSender.sendNotification(env, rec);
        }
    }

    @Override
    public void triggerNamespaceRegistered(IId aNID) throws CException {
        HashSet<CTargetAddress> observers = new HashSet<CTargetAddress>();
        this.privateFilterObservers(aNID, observers);
        for (CTargetAddress a : observers) {
            CEnvelope env = CEnvelope.forSingleTarget(a);
            env.setSender(this.mMyAddress);
            CRecord rec = CRecordNamespaceMonitorNotifyNamespaceRegistered.create();
            CRecordNamespaceMonitorNotifyNamespaceRegistered.setNid(rec, aNID);
            this.mMessageSender.sendNotification(env, rec);
        }
    }
}

