/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.namedb;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.namedb.ITargetAddressDatabase;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CTargetAddressDatabase
implements ITargetAddressDatabase {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetAddressDatabase.class);
    private static final int MAP_SIZE = 100;
    private final Map<CTargetAddress, String> mDb = new ConcurrentHashMap<CTargetAddress, String>(100);

    CTargetAddressDatabase() {
    }

    @Override
    public void dump() {
        LOG.info("TargetNameDb: size={}", this.mDb.size());
        for (Map.Entry<CTargetAddress, String> entry : this.mDb.entrySet()) {
            LOG.trace("{} = {}", entry.getKey(), entry.getValue());
        }
    }

    @Override
    @NotNull
    public String getName(@NotNull CTargetAddress aAddress) {
        String name = this.mDb.get(aAddress);
        if (name == null) {
            name = aAddress.toString();
        }
        return name;
    }

    @Override
    @Nullable
    public String getNameOrNull(@NotNull CTargetAddress aAddress) {
        return this.mDb.get(aAddress);
    }

    @Override
    public void putName(@NotNull CTargetAddress aAddress, @NotNull String aName) {
        this.mDb.put(aAddress, aName);
    }

    @Override
    public void removeName(@NotNull CTargetAddress aAddress) {
        this.mDb.remove(aAddress);
    }
}

