/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config;

import de.sillysky.nyssr.impl.kernel.config.EConfigurationSource;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CConfigurationEntry
implements Comparable<CConfigurationEntry> {
    private static final ILogger LOG = CLoggerFactory.getLogger(CConfigurationEntry.class);
    private final String mKey;
    private final String mPath;
    private EConfigurationSource mSource;
    private String mValue;
    private final String mPathKey;

    CConfigurationEntry(@NotNull EConfigurationSource aSource, @NotNull String aPath, @NotNull String aKey, @Nullable String aValue) {
        this.mSource = aSource;
        this.mKey = aKey;
        this.mPath = CUtilString.removeLastChar(aPath, '/');
        this.mValue = aValue;
        this.mPathKey = this.mPath + "/" + this.mKey;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CConfigurationEntry that = (CConfigurationEntry)aO;
        return this.mKey.equals(that.mKey) && this.mPath.equals(that.mPath);
    }

    public int hashCode() {
        return Objects.hash(this.mKey, this.mPath);
    }

    public EConfigurationSource getSource() {
        return this.mSource;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getValue() {
        return this.mValue;
    }

    public void setValue(@NotNull EConfigurationSource aSource, @Nullable String aValue) {
        if (aSource.ordinal() <= this.mSource.ordinal()) {
            this.mSource = aSource;
            this.mValue = aValue;
            LOG.debug("From {}: set {} = {}", this.mSource.name(), this.mPathKey, this.mValue);
        }
    }

    public String getPath() {
        return this.mPath;
    }

    public String getPathKey() {
        return this.mPathKey;
    }

    @Override
    public int compareTo(@NotNull CConfigurationEntry aOther) {
        return this.mPathKey.compareTo(aOther.mPathKey);
    }

    public String toString() {
        return this.mPathKey + " = " + this.mValue + " (from " + (Object)((Object)this.mSource) + ")";
    }
}

