/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.cli;

import de.sillysky.nyssr.impl.cli.CCommandLineInterfaceTarget;
import de.sillysky.nyssr.impl.cli.IDependencies;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import org.jetbrains.annotations.NotNull;

public class CPackageImplCli
implements IServiceStarter,
IDependencies {
    private IService mService = null;
    private INamespaceRegistry mNamespaceRegistry;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespaceRegistry.class);
        aDependencyList.add(ITargetRegistry.class);
        aDependencyList.add(INamespace.class, "nid=SYSTEM");
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mNamespaceRegistry = aServiceRegistry.getServiceOrThrow(INamespaceRegistry.class);
            this.mService = new CCommandLineInterfaceTarget(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    public INamespaceRegistry getNamespaceRegistry() {
        return this.mNamespaceRegistry;
    }
}

