/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.id.string;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class CIdString
implements IId {
    @NotNull
    private final String mValue;

    CIdString(@NotNull String aID) {
        this.mValue = aID;
    }

    @Override
    public int compareTo(@NotNull IId aOther) {
        return CIdFactory.compareTo(this, aOther);
    }

    @Override
    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CIdString cIdString = (CIdString)aO;
        return this.mValue.equals(cIdString.mValue);
    }

    @NotNull
    public String getString() {
        return this.mValue;
    }

    @Override
    @NotNull
    public EIdType getType() {
        return EIdType.STRING;
    }

    @Override
    public int hashCode() {
        return this.mValue.hashCode();
    }

    @Override
    public boolean isValid() {
        return !this.mValue.isEmpty();
    }

    @Override
    @NotNull
    public String toShortString() {
        return this.mValue;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        byte b = this.getType().getValue();
        aStream.writeByte(b);
        CUtilString.toStream(aStream, this.mValue);
    }

    public String toString() {
        return this.mValue;
    }

    @Override
    @NotNull
    public String valueToString() {
        return this.mValue;
    }
}

