/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.cli.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordCliHandle
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("d9c9e057-b172-40a5-8ae0-23d51e226321");
    public static final String NAME = "CliHandle";
    public static final String DESCRIPTION = "Forward the command line to the command line manager.";
    public static final String SLOT_ARGUMENTS = "5";
    public static final String SLOT_COMMAND = "4";
    public static final String SLOT_COMMAND_LINE = "2";
    public static final String SLOT_DISPLAY = "3";
    public static final String SLOT_IS_VALID_COMMAND = "10";
    public static final String SLOT_OUTPUT = "11";
    public static final String SLOT_SESSION_TOKEN = "1";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getArguments(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ARGUMENTS);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String getCommand(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COMMAND);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getCommandLine(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COMMAND_LINE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CTargetAddress getDisplay(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DISPLAY);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static boolean getIsValidCommand(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_IS_VALID_COMMAND);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getOutput(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OUTPUT);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getSessionToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setArguments(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_ARGUMENTS, slot);
    }

    public static void setCommand(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_COMMAND, slot);
    }

    public static void setCommandLine(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_COMMAND_LINE, slot);
    }

    public static void setDisplay(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_DISPLAY, slot);
    }

    public static void setIsValidCommand(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_IS_VALID_COMMAND, slot);
    }

    public static void setOutput(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_OUTPUT, slot);
    }

    public static void setSessionToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_SESSION_TOKEN, slot);
    }
}

