/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSegmentId
implements Comparable<CSegmentId> {
    public static final CSegmentId EMPTY = new CSegmentId();
    private static final AtomicReference<CSegmentId> mLocalSegmentId = new AtomicReference<CSegmentId>(EMPTY);
    @NotNull
    private final IId mId;

    public CSegmentId() {
        this.mId = IId.INVALID;
    }

    public CSegmentId(@NotNull String aString) {
        this.mId = CIdFactory.fromObject(aString);
    }

    public CSegmentId(@NotNull UUID aUuid) {
        this.mId = CIdFactory.fromObject(EIdType.UUID, aUuid);
    }

    public CSegmentId(@NotNull IId aId) {
        this.mId = aId;
    }

    public static CSegmentId getLocal() {
        return mLocalSegmentId.get();
    }

    public static boolean isLocal(@Nullable CSegmentId aSegmentId) {
        return CSegmentId.isEmpty(aSegmentId) || mLocalSegmentId.get().equals(aSegmentId);
    }

    public static boolean isValid(@Nullable CSegmentId aSegmentId) {
        return !CSegmentId.isEmpty(aSegmentId);
    }

    public static boolean isEmpty(@Nullable CSegmentId aSegmentId) {
        return aSegmentId == null || EMPTY.equals(aSegmentId);
    }

    @Nullable
    public static CSegmentId fromStream(@NotNull DataInput aStream) throws IOException {
        boolean valid = aStream.readBoolean();
        if (!valid) {
            return null;
        }
        IId id = CIdFactory.fromStream(aStream, true);
        return new CSegmentId(id == null ? IId.INVALID : id);
    }

    @NotNull
    public static CSegmentId fromObject(@NotNull Object aElement) {
        IId id = CIdFactory.fromObject(aElement);
        return new CSegmentId(id);
    }

    public static boolean equals(@Nullable CSegmentId aId1, @Nullable CSegmentId aId2) {
        if (CSegmentId.isEmpty(aId1)) {
            return CSegmentId.isEmpty(aId2);
        }
        return aId1.equals(aId2);
    }

    @NotNull
    public static CSegmentId random() {
        return new CSegmentId(CUtilUuid.random());
    }

    @Override
    public int compareTo(@NotNull CSegmentId aOther) {
        return this.mId.compareTo(aOther.mId);
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CSegmentId that = (CSegmentId)aO;
        return this.mId.equals(that.mId);
    }

    @NotNull
    public IId getId() {
        return this.mId;
    }

    public int hashCode() {
        return this.mId.hashCode();
    }

    public boolean isLocal() {
        if (!this.mId.isValid()) {
            return true;
        }
        return this.equals(mLocalSegmentId.get());
    }

    public static void setLocal(@NotNull CSegmentId aSegmentId) {
        mLocalSegmentId.set(aSegmentId);
    }

    public boolean isValid() {
        return this.mId.isValid();
    }

    public boolean isEmpty() {
        return EMPTY.equals(this);
    }

    public String toString() {
        return this.mId.isValid() ? this.mId.toString() : "";
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable CSegmentId aValue) throws IOException {
        if (aValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            CIdFactory.toStream(aStream, aValue.mId);
        }
    }

    @NotNull
    public String valueToString() {
        return this.mId.isValid() ? this.mId.valueToString() : "";
    }

    public boolean match(@Nullable CSegmentId aSegmentId) {
        if (CSegmentId.isEmpty(aSegmentId)) {
            return this.isLocal();
        }
        return this.equals(aSegmentId);
    }
}

