/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CNodeAddress
implements Comparable<CNodeAddress> {
    public static final CNodeAddress EMPTY = new CNodeAddress(true);
    private static final char DOT = '.';
    private final CNodeId mNodeId;
    private final CSegmentId mSegmentId;

    public CNodeAddress() {
        this.mNodeId = CNodeId.getLocal();
        this.mSegmentId = CSegmentId.getLocal();
    }

    private CNodeAddress(boolean aCreateEmpty) {
        this.mNodeId = CNodeId.EMPTY;
        this.mSegmentId = CSegmentId.EMPTY;
    }

    public CNodeAddress(@NotNull CNodeId aNodeId) {
        CUtilCheck.checkNotNull(aNodeId, "NodeId is null", new Object[0]);
        this.mNodeId = aNodeId.isEmpty() ? CNodeId.getLocal() : aNodeId;
        this.mSegmentId = CSegmentId.getLocal();
    }

    public CNodeAddress(@NotNull CNodeId aNodeId, @NotNull CSegmentId aSegmentId) {
        CUtilCheck.checkNotNull(aNodeId, "NodeId is null", new Object[0]);
        CUtilCheck.checkNotNull(aSegmentId, "SegmentId is null", new Object[0]);
        this.mNodeId = aNodeId.isEmpty() ? CNodeId.getLocal() : aNodeId;
        this.mSegmentId = aSegmentId.isEmpty() ? CSegmentId.getLocal() : aSegmentId;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static CNodeAddress fromString(@Nullable String aValue) {
        if (CUtilString.isEmpty(aValue)) {
            return new CNodeAddress(CNodeId.getLocal(), CSegmentId.getLocal());
        }
        String s = aValue.trim();
        String[] split = s.split("[.]");
        if (split.length == 1) {
            CNodeId nodeId = CNodeId.fromObject(split[0]);
            return new CNodeAddress(nodeId, CSegmentId.EMPTY);
        }
        if (split.length == 2) {
            CNodeId nodeId = CNodeId.fromObject(split[0]);
            CSegmentId segmentId = new CSegmentId(split[1]);
            return new CNodeAddress(nodeId, segmentId);
        }
        return new CNodeAddress(CNodeId.getLocal(), CSegmentId.getLocal());
    }

    @NotNull
    public static CNodeAddress getLocal() {
        return new CNodeAddress(CNodeId.getLocal(), CSegmentId.getLocal());
    }

    @Nullable
    public static CNodeAddress fromStream(@NotNull DataInput aStream) throws IOException {
        boolean valid = aStream.readBoolean();
        if (valid) {
            CNodeId nodeId = CNodeId.fromStream(aStream);
            CSegmentId segmentId = CSegmentId.fromStream(aStream);
            if (nodeId != null && segmentId != null) {
                return new CNodeAddress(nodeId, segmentId);
            }
            System.err.println("temp");
        }
        return null;
    }

    public static boolean isEqual(@Nullable CNodeAddress aValue1, @Nullable CNodeAddress aValue2) {
        if (aValue1 == null) {
            return aValue2 == null;
        }
        return aValue1.equals(aValue2);
    }

    @NotNull
    public static CNodeAddress random() {
        return new CNodeAddress(CNodeId.random(), CSegmentId.random());
    }

    public static boolean logicalEquals(@Nullable CNodeAddress aNodeId1, @Nullable CNodeAddress aNodeId2) {
        if (aNodeId1 == aNodeId2) {
            return true;
        }
        if (aNodeId1 == null || EMPTY.equals(aNodeId1)) {
            return aNodeId2 == null || aNodeId2.isLocalNode();
        }
        if (aNodeId2 == null || EMPTY.equals(aNodeId2)) {
            return aNodeId1.isLocalNode();
        }
        return aNodeId1.equals(aNodeId2);
    }

    public static boolean isValid(@Nullable CNodeAddress aValue) {
        return aValue != null && CNodeId.isValid(aValue.getNodeId());
    }

    @NotNull
    public CNodeId getNodeId() {
        return this.mNodeId;
    }

    @NotNull
    public CSegmentId getSegmentId() {
        return this.mSegmentId;
    }

    public boolean isLocalNode() {
        if (!CNodeId.isLocal(this.mNodeId)) {
            return false;
        }
        return this.mSegmentId.isLocal();
    }

    public boolean matchNodeId(@Nullable CNodeId aNodeId) {
        return this.mNodeId.equals(aNodeId);
    }

    public boolean matchSegmentId(@Nullable CSegmentId aSegmentId) {
        return this.mSegmentId.match(aSegmentId);
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable CNodeAddress aValue) throws IOException {
        if (aValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            CNodeId.toStream(aStream, aValue.mNodeId);
            CSegmentId.toStream(aStream, aValue.mSegmentId);
        }
    }

    @NotNull
    public String valueToString() {
        return this.mNodeId.valueToString() + '.' + this.mSegmentId.valueToString();
    }

    public String toString() {
        return this.mNodeId.toString() + '.' + this.mSegmentId;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CNodeAddress that = (CNodeAddress)aO;
        return this.mNodeId.equals(that.mNodeId) && this.mSegmentId.equals(that.mSegmentId);
    }

    public int hashCode() {
        return Objects.hash(this.mNodeId, this.mSegmentId);
    }

    @Override
    public int compareTo(@NotNull CNodeAddress aOther) {
        int result = this.mNodeId.compareTo(aOther.getNodeId());
        if (result == 0) {
            result = this.mSegmentId.compareTo(aOther.getSegmentId());
        }
        return result;
    }

    public boolean isValid() {
        return this.mNodeId.isValid();
    }

    public boolean isComplete() {
        return this.getNodeId().isValid() && this.getSegmentId().isValid();
    }
}

