/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.network.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.CApplicationInstance;
import de.sillysky.nyssr.app.IApplicationInstanceRegistry;
import de.sillysky.nyssr.app.records.CRecordNotifyAppInstanceStarted;
import de.sillysky.nyssr.app.records.CRecordNotifyAppInstanceStopped;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.network.index.INetworkIndex;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexAddAppInstance;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexRemoveAppInstance;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CTargetAppNetwork
extends CTarget
implements IService {
    private IRecordHelper mRecordHelper;
    private INetworkIndex mNetworkIndex;

    CTargetAppNetwork() {
    }

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(INetworkIndex.class);
        aDependencyList.add(IApplicationInstanceRegistry.class);
        aDependencyList.add(IRecordHelper.class);
        aDependencyList.add(INamespaceFactory.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getService(IRecordHelper.class);
        this.mNetworkIndex = (INetworkIndex)aServiceRegistry.getService(INetworkIndex.class);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNotifyAppInstanceStarted.ID, this::asyncNotifyAppInstanceStarted);
        this.addMessageHandler(CRecordNotifyAppInstanceStopped.ID, this::asyncNotifyAppInstanceStopped);
        INamespaceFactory nsf = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        INamespace ns = nsf.createAndRegisterNamespace(CWellKnownNID.TRANSPORT, "Transport");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    private boolean asyncNotifyAppInstanceStarted(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        CTargetAddress address = this.mNetworkIndex.getAddressOfNextNetworkIndex();
        if (address != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord ai = CRecordNotifyAppInstanceStarted.getInstance((CRecord)aRecord, null);
            CRecord record = CRecordNetworkIndexAddAppInstance.create();
            CRecordNetworkIndexAddAppInstance.setAppInstance((CRecord)record, (CRecord)ai);
            this.send(env, record);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyAppInstanceStopped(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        CTargetAddress address = this.mNetworkIndex.getAddressOfNextNetworkIndex();
        if (address != null) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord air = CRecordNotifyAppInstanceStopped.getInstance((CRecord)aRecord, null);
            CApplicationInstance ai = CApplicationInstance.create((CRecord)air);
            if (ai != null) {
                CRecord record = CRecordNetworkIndexRemoveAppInstance.create();
                CRecordNetworkIndexRemoveAppInstance.setAppInstanceId((CRecord)record, (UUID)ai.getInstanceId());
                this.send(env, record);
            }
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        this.mRecordHelper.addObserver(CRecordNotifyAppInstanceStarted.class, (ITarget)this, true);
        this.mRecordHelper.addObserver(CRecordNotifyAppInstanceStopped.class, (ITarget)this, true);
        aEnvelope.setResultSuccess();
        return true;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mRecordHelper.removeObserver(CRecordNotifyAppInstanceStarted.class, (ITarget)this);
        this.mRecordHelper.removeObserver(CRecordNotifyAppInstanceStopped.class, (ITarget)this);
        this.deregisterTarget();
    }
}

