/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.node.list;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.network.node.list.CDialogNodeListTarget;
import de.sillysky.nyssr.impl.network.node.list.IDependencies;
import de.sillysky.nyssr.impl.network.node.list.records.CRecordUpdateDialogNodeList;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.network.router.records.CRecordNetworkGetListOfLocalReachableNodeInfos;
import de.sillysky.nyssr.network.router.records.CRecordNetworkNotifyNodeRecordUpdated;
import de.sillysky.nyssr.node.list.CConstantsNodeList;
import de.sillysky.nyssr.node.list.records.CRecordOpenDialogNodeList;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeAdded;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialog;
import de.sillysky.nyssr.remoteskin.server.dialog.CBasicDialogFactory;
import de.sillysky.nyssr.remoteskin.server.dialog.CDialogDto;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

class CDialogNodeListFactory
extends CBasicDialogFactory
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger((String)"dialog.nodelist");
    private final List<INamespace> mNamespaces = new ArrayList<INamespace>();
    private final IDependencies mDependencies;
    private CRecord[] mLocalNodes = new CRecord[0];
    private IId mMicroServiceId;

    CDialogNodeListFactory(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        LOG.debug("Module DialogNodeList has been started.");
        IKernelConfiguration kernelConfiguration = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
        this.readPreferences(kernelConfiguration);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordOpenDialogNodeList.ID, this::asyncOpenDialogNodeList);
        this.addMessageHandler(CRecordNetworkGetListOfLocalReachableNodeInfos.ID, this::asyncGetListOfLocalReachableNodeInfos);
        this.addMessageHandler(CRecordUpdateDialogNodeList.ID, this::asyncAnswerRecordUpdate);
        this.addMessageHandler(CRecordNotifyRemoteNodeAdded.ID, this::asyncNotifyRemoteNodeAdded);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        this.addMessageHandler(CRecordNetworkNotifyNodeRecordUpdated.ID, this::asyncNetworkNotifyNodeRecordUpdated);
        IId nid = CIdFactory.random((String)"DialogNodeList");
        INamespace ns = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "DialogNodeList");
        this.mNamespaces.add(ns);
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void notifyTargetWillBeRemoved() throws Exception {
        this.mDependencies.getHelperForLocalMicroServices().deregisterMicroServices(this.getAddress());
        super.notifyTargetWillBeRemoved();
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.deregisterTarget();
        LOG.debug("Module DialogNodeList has been removed.");
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        IRecordHelper recordHelper = this.mDependencies.getRecordHelper();
        recordHelper.addObserver(CRecordNotifyRemoteNodeAdded.class, (ITarget)this, false);
        recordHelper.addObserver(CRecordNetworkNotifyNodeRecordUpdated.class, (ITarget)this, false);
        this.sendGetLocalReachableNodes();
        this.registerMicroService();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetListOfLocalReachableNodeInfos(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.mLocalNodes = CRecordNetworkGetListOfLocalReachableNodeInfos.getNodes((CRecord)aRecord, null);
            this.sendUpdates(this.mLocalNodes);
            return true;
        }
        return false;
    }

    private boolean asyncOpenDialogNodeList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CDialogDto dto = this.checkStartDialog(aEnvelope, aRecord);
        String name = CRecordOpenDialogNodeList.getName((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)name, (String)"Missing Widget Set File Name", (Object[])new Object[0]);
        INamespace namespace = this.createNamespace();
        CDialogNodeListTarget tgt = new CDialogNodeListTarget(this.mDependencies, dto, name, this.mLocalNodes);
        namespace.getTargetRegistry().registerTarget((ITarget)tgt);
        if (this.mLocalNodes.length == 0) {
            this.sendGetLocalReachableNodes();
        }
        this.addDialog(tgt);
        CRecordOpenDialogNodeList.setAddressOfDialog((CRecord)aRecord, (CTargetAddress)tgt.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private INamespace createNamespace() throws CException {
        INamespace namespace = null;
        for (INamespace ns : this.mNamespaces) {
            if (ns.getTargetRegistry().size() >= 1000) continue;
            namespace = ns;
            break;
        }
        if (namespace == null) {
            IId nid = CIdFactory.random((String)"DialogNodeList");
            namespace = this.mDependencies.getNamespaceFactory().createAndRegisterNamespace(nid, "DialogNodeList");
            this.mNamespaces.add(namespace);
        }
        return namespace;
    }

    private boolean asyncAnswerRecordUpdate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            if (!aEnvelope.getResult().isSuccess()) {
                UUID uUID = CRecordUpdateDialogNodeList.getId(aRecord, null);
            }
            return true;
        }
        return false;
    }

    private boolean asyncNotifyRemoteNodeAdded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeAdded.getRemoteNode((CRecord)aRecord, null);
        if (node.getSegmentId().isLocal()) {
            this.sendGetLocalReachableNodes();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (!aEnvelope.isAnswer()) {
            CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
            if (node.getSegmentId().isLocal()) {
                this.sendGetLocalReachableNodes();
            }
            aEnvelope.setResultSuccess();
        }
        return false;
    }

    private boolean asyncNetworkNotifyNodeRecordUpdated(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNetworkNotifyNodeRecordUpdated.getRemoteNode((CRecord)aRecord, null);
        if (node.getSegmentId().isLocal()) {
            this.sendGetLocalReachableNodes();
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private void sendGetLocalReachableNodes() throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        CRecord record = CRecordNetworkGetListOfLocalReachableNodeInfos.create();
        this.sendRequest(env, record);
    }

    private void sendUpdates(@NotNull CRecord[] aAddresses) throws CException {
        for (CBasicDialog child : this.getChildren()) {
            CDialogNodeListTarget tgt = (CDialogNodeListTarget)child;
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)tgt.getAddress());
            CRecord record = CRecordUpdateDialogNodeList.create();
            CRecordUpdateDialogNodeList.setId(record, tgt.getDialogDto().getDialogInstanceId());
            CRecordUpdateDialogNodeList.setNodes(record, aAddresses);
            this.sendNotification(env, record);
        }
    }

    private void registerMicroService() throws CException {
        ArrayList<CDescriptionOfRecord> nanos = new ArrayList<CDescriptionOfRecord>();
        nanos.add(new CDescriptionOfRecord(CRecordOpenDialogNodeList.ID, "Show Dialog"));
        this.mDependencies.getHelperForLocalMicroServices().registerMicroService(CConstantsNodeList.MICRO_SERVICE_ID, "Node List Dialog", nanos, this.mMicroServiceId, this.getAddress());
    }

    private void readPreferences(@NotNull IKernelConfiguration aKernelConfiguration) {
        Preferences preferences = aKernelConfiguration.getPreferences("dialogNodeList");
        String s = preferences.get("microservice.instance.id", CNodeId.getLocal().toString());
        this.mMicroServiceId = CIdFactory.fromObject((Object)s);
    }

    @NotNull
    protected String getDialogName() {
        return "NodeList";
    }

    @NotNull
    protected ILogger getLogger() {
        return LOG;
    }
}

