/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events.border;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventStroke;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.remoteskin.model.events.border.EBorderType;
import de.sillysky.nyssr.remoteskin.model.events.border.IBorder;
import java.awt.BasicStroke;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventStrokeBorder
implements IBorder,
IRemoteSkinEvent {
    private final BasicStroke mStroke;
    private final Color mColor;

    public CEventStrokeBorder(@NotNull BasicStroke aStroke, @NotNull Color aColor) {
        this.mStroke = aStroke;
        this.mColor = aColor;
    }

    @Nullable
    public static CEventStrokeBorder create(@Nullable Object aValue) {
        CJsonObject jo;
        Object o;
        CEventStroke es;
        if (aValue instanceof CJsonObject && (es = CEventStroke.create(o = (jo = (CJsonObject)aValue).getValue(EKeys.stroke.name()))) != null) {
            o = jo.getValue(EKeys.color.name());
            CEventColor dc = CEventColor.create(o);
            Color color = dc == null ? Color.BLACK : dc.createColor();
            return new CEventStrokeBorder(es.createStroke(), color);
        }
        return null;
    }

    @NotNull
    public BasicStroke getStroke() {
        return this.mStroke;
    }

    @NotNull
    public Color getColor() {
        return this.mColor;
    }

    @Override
    @NotNull
    public Border createBorder() {
        return BorderFactory.createStrokeBorder(this.mStroke, this.mColor);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.border_type.name(), (Object)this.getType().name());
        CEventStroke st = new CEventStroke(this.mStroke);
        jo.put(EKeys.stroke.name(), st.toJson());
        CEventColor dc = new CEventColor(this.mColor);
        jo.put(EKeys.color.name(), dc.toJson());
        return jo;
    }

    @Override
    public EBorderType getType() {
        return EBorderType.stroke;
    }

    public static enum EKeys {
        border_type,
        stroke,
        color;

    }
}

