/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonFloat;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonFloatArray;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonString;
import de.sillysky.nyssr.remoteskin.model.enums.EStrokeCap;
import de.sillysky.nyssr.remoteskin.model.enums.EStrokeJoin;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import de.sillysky.nyssr.util.CUtilEnum;
import java.awt.BasicStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventStroke
implements IRemoteSkinEvent {
    private static final float INVALID = -1.0f;
    private final float mWidth;
    private final EStrokeCap mCap;
    private final EStrokeJoin mJoin;
    private final float mMiterLimit;
    private final float[] mDashArray;
    private final float mDashPhase;

    public CEventStroke(float aWidth, @NotNull EStrokeCap aCap, @NotNull EStrokeJoin aJoin, float aMiterLimit, float[] aDashArray, float aDashPhase) {
        this.mWidth = aWidth;
        this.mCap = aCap;
        this.mJoin = aJoin;
        this.mMiterLimit = aMiterLimit;
        this.mDashArray = aDashArray;
        this.mDashPhase = aDashPhase;
    }

    public CEventStroke(@NotNull BasicStroke aStroke) {
        this.mWidth = aStroke.getLineWidth();
        switch (aStroke.getEndCap()) {
            case 0: {
                this.mCap = EStrokeCap.butt;
                break;
            }
            case 1: {
                this.mCap = EStrokeCap.round;
                break;
            }
            default: {
                this.mCap = EStrokeCap.square;
            }
        }
        switch (aStroke.getLineJoin()) {
            case 1: {
                this.mJoin = EStrokeJoin.round;
                break;
            }
            case 2: {
                this.mJoin = EStrokeJoin.bevel;
                break;
            }
            default: {
                this.mJoin = EStrokeJoin.miter;
            }
        }
        this.mMiterLimit = aStroke.getMiterLimit();
        this.mDashArray = aStroke.getDashArray();
        this.mDashPhase = aStroke.getDashPhase();
    }

    @Nullable
    public static CEventStroke create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            float width = CUtilJsonFloat.fromJson((CJsonObject)jo, (String)EKeys.width.name(), (float)-1.0f);
            String s = CUtilJsonString.fromJson((CJsonObject)jo, (String)EKeys.cap.name(), null);
            EStrokeCap cap = (EStrokeCap)((Object)CUtilEnum.fromString(EStrokeCap.class, (String)s, (Object)((Object)EStrokeCap.unknown)));
            s = CUtilJsonString.fromJson((CJsonObject)jo, (String)EKeys.join.name(), null);
            EStrokeJoin join = (EStrokeJoin)((Object)CUtilEnum.fromString(EStrokeJoin.class, (String)s, (Object)((Object)EStrokeJoin.unknown)));
            float miterlimit = CUtilJsonFloat.fromJson((CJsonObject)jo, (String)EKeys.miterlimit.name(), (float)-1.0f);
            float[] dash = CUtilJsonFloatArray.fromJson((CJsonObject)jo, (String)EKeys.dash.name(), null);
            float dashPhase = CUtilJsonFloat.fromJson((CJsonObject)jo, (String)EKeys.dashphase.name(), (float)-1.0f);
            return new CEventStroke(width, cap, join, miterlimit, dash, dashPhase);
        }
        return null;
    }

    public float getWidth() {
        return this.mWidth;
    }

    public EStrokeCap getCap() {
        return this.mCap;
    }

    public EStrokeJoin getJoin() {
        return this.mJoin;
    }

    public float getMiterLimit() {
        return this.mMiterLimit;
    }

    public float[] getDashArray() {
        return this.mDashArray;
    }

    public float getDashPhase() {
        return this.mDashPhase;
    }

    public BasicStroke createStroke() {
        if (this.mWidth >= 0.0f) {
            if (this.mCap != EStrokeCap.unknown && this.mJoin != EStrokeJoin.unknown) {
                int join;
                int cap;
                switch (this.mCap) {
                    case butt: {
                        cap = 0;
                        break;
                    }
                    case round: {
                        cap = 1;
                        break;
                    }
                    default: {
                        cap = 2;
                    }
                }
                switch (this.mJoin) {
                    case round: {
                        join = 1;
                        break;
                    }
                    case bevel: {
                        join = 2;
                        break;
                    }
                    default: {
                        join = 0;
                    }
                }
                if (this.mMiterLimit >= 0.0f) {
                    if (this.mDashArray != null && this.mDashArray.length > 0) {
                        return new BasicStroke(this.mWidth, cap, join, this.mMiterLimit, this.mDashArray, this.mDashPhase);
                    }
                    return new BasicStroke(this.mWidth, cap, join, this.mMiterLimit);
                }
                return new BasicStroke(this.mWidth, cap, join);
            }
            return new BasicStroke(this.mWidth);
        }
        return new BasicStroke();
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        jo.put(EKeys.width.name(), (Object)Float.valueOf(this.mWidth));
        if (this.mCap != EStrokeCap.unknown) {
            jo.put(EKeys.cap.name(), (Object)this.mCap.name());
        }
        if (this.mJoin != EStrokeJoin.unknown) {
            jo.put(EKeys.join.name(), (Object)this.mJoin.name());
        }
        jo.put(EKeys.miterlimit.name(), (Object)Float.valueOf(this.mMiterLimit));
        if (this.mDashArray != null && this.mDashArray.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (float f : this.mDashArray) {
                arr.add((Object)Float.valueOf(f));
            }
            jo.put(EKeys.dash.name(), (Object)arr);
        }
        jo.put(EKeys.dashphase.name(), (Object)Float.valueOf(this.mDashPhase));
        return jo;
    }

    public static enum EKeys {
        width,
        cap,
        join,
        miterlimit,
        dash,
        dashphase;

    }
}

