/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.jsonio.basic.CUtilJsonInteger;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventMinMaxPreferred
implements IRemoteSkinEvent {
    public static final String INDEX = "index";
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String PREFERRED = "pref";
    private final int mIndex;
    private final int mMinimum;
    private final int mMaximum;
    private final int mPreferred;

    public CEventMinMaxPreferred(int aIndex, int aMinimum, int aMaximum, int aPreferred) {
        this.mIndex = aIndex;
        this.mMinimum = aMinimum;
        this.mMaximum = aMaximum;
        this.mPreferred = aPreferred;
    }

    public CEventMinMaxPreferred(int aMinimum, int aMaximum, int aPreferred) {
        this.mIndex = Integer.MIN_VALUE;
        this.mMinimum = aMinimum;
        this.mMaximum = aMaximum;
        this.mPreferred = aPreferred;
    }

    @Nullable
    public static CEventMinMaxPreferred create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            int index = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)INDEX, (int)Integer.MIN_VALUE);
            int min = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)MIN, (int)0);
            int max = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)MAX, (int)0);
            int preferred = CUtilJsonInteger.fromJson((CJsonObject)jo, (String)PREFERRED, (int)0);
            return new CEventMinMaxPreferred(index, min, max, preferred);
        }
        return null;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public int getMinimum() {
        return this.mMinimum;
    }

    public int getMaximum() {
        return this.mMaximum;
    }

    public int getPreferred() {
        return this.mPreferred;
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        if (this.mIndex >= 0) {
            jo.put(INDEX, (Object)this.mIndex);
        }
        jo.put(MIN, (Object)this.mMinimum);
        jo.put(MAX, (Object)this.mMaximum);
        jo.put(PREFERRED, (Object)this.mPreferred);
        return jo;
    }
}

