/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.link.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.link.collector.CLink;
import de.sillysky.nyssr.impl.link.collector.CLinkList;
import de.sillysky.nyssr.impl.link.collector.CSegmentRoutingHint;
import de.sillysky.nyssr.impl.link.collector.CSegmentRoutingHintList;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.link.collector.CConstants;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorAddLink;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorAddRoutingHint;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorForwardToNextNode;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorGetNextHop;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorRemoveLink;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorRemoveRoutingHint;
import de.sillysky.nyssr.link.collector.records.CRecordLinkCollectorSyncLinks;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.microservice.helper.IHelperForLocalMicroServices;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.nanoservice.CDescriptionOfRecord;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.network.transport.records.CRecordForwardMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.NotNull;

public class CLinkCollectorTarget
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CLinkCollectorTarget.class);
    private final CLinkList mLinks = new CLinkList();
    private final CSegmentRoutingHintList mHints = new CSegmentRoutingHintList();
    private INamespaceFactory mNamespaceFactory;
    private IHelperForLocalMicroServices mHelperForLocalMicroServices;
    private IId mMicroServiceInstanceId;

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordLinkCollectorAddRoutingHint.ID, this::asyncAddRoutingHint);
        this.addMessageHandler(CRecordLinkCollectorForwardToNextNode.ID, this::asyncForwardToNextNode);
        this.addMessageHandler(CRecordLinkCollectorGetNextHop.ID, this::asyncGetNextHop);
        this.addMessageHandler(CRecordLinkCollectorRemoveRoutingHint.ID, this::asyncRemoveRoutingHint);
        this.addMessageHandler(CRecordLinkCollectorAddLink.ID, this::asyncAddLink);
        this.addMessageHandler(CRecordLinkCollectorRemoveLink.ID, this::asyncRemoveLink);
        this.addMessageHandler(CRecordLinkCollectorSyncLinks.ID, this::asyncSyncLinks);
        IKernelConfiguration kc = (IKernelConfiguration)aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
        Preferences preferences = kc.getPreferences("linkCollector");
        String s = preferences.get("microservice.instance.id", CNodeId.getLocal().toString());
        this.mMicroServiceInstanceId = CIdFactory.fromObject((Object)s);
        this.mHelperForLocalMicroServices = (IHelperForLocalMicroServices)aServiceRegistry.getServiceOrThrow(IHelperForLocalMicroServices.class);
        this.mNamespaceFactory = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        IId nid = CIdFactory.random((String)"LinkCollector");
        INamespace ns = this.mNamespaceFactory.createAndRegisterNamespace(nid, "LinkCollector");
        ns.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.mHelperForLocalMicroServices.deregisterMicroServices(this.getAddress());
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        LOG.info("Start Link Collector Target");
        CTargetAddress address = this.getAddress();
        INamespace ns = this.mNamespaceFactory.getNamespace(CWellKnownNID.SYSTEM);
        INanoServiceRegistry sr = ns.getNanoServiceRegistry();
        sr.addObserver(CRecordLinkCollectorAddRoutingHint.ID, address);
        sr.addObserver(CRecordLinkCollectorForwardToNextNode.ID, address);
        sr.addObserver(CRecordLinkCollectorGetNextHop.ID, address);
        sr.addObserver(CRecordLinkCollectorRemoveRoutingHint.ID, address);
        ArrayList<CDescriptionOfRecord> nanoList = new ArrayList<CDescriptionOfRecord>();
        nanoList.add(new CDescriptionOfRecord(CRecordLinkCollectorAddRoutingHint.ID, "Add a Routing Hint"));
        nanoList.add(new CDescriptionOfRecord(CRecordLinkCollectorForwardToNextNode.ID, "Forward a message to another node"));
        nanoList.add(new CDescriptionOfRecord(CRecordLinkCollectorGetNextHop.ID, "Get a Routing Hint for a Segment"));
        nanoList.add(new CDescriptionOfRecord(CRecordLinkCollectorRemoveRoutingHint.ID, "Remove a Routing Hint"));
        nanoList.add(new CDescriptionOfRecord(CRecordLinkCollectorAddLink.ID, "Add a link between two nodes"));
        nanoList.add(new CDescriptionOfRecord(CRecordLinkCollectorRemoveLink.ID, "Remove a Link"));
        nanoList.add(new CDescriptionOfRecord(CRecordLinkCollectorSyncLinks.ID, "All direct links of the sender node"));
        this.mHelperForLocalMicroServices.registerMicroService(CConstants.MICRO_SERVICE_ID, "Collect Links and Routing Hints for Segments", nanoList, this.mMicroServiceInstanceId, this.getAddress());
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddRoutingHint(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeId node = CRecordLinkCollectorAddRoutingHint.getRoutingNode((CRecord)aRecord, (CNodeId)aEnvelope.getSender().getNodeId());
        CUtilCheck.checkNotNull((Object)node, (String)"Missing routing node ID", (Object[])new Object[0]);
        CSegmentId segment = CRecordLinkCollectorAddRoutingHint.getSegment((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)segment, (String)"Missing foreign segment", (Object[])new Object[0]);
        CSegmentRoutingHint hint = new CSegmentRoutingHint(segment, node);
        LOG.debug("Add Routing Hint: {}", new Object[]{hint});
        this.mHints.add(hint);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncForwardToNextNode(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CMessage message = CRecordLinkCollectorForwardToNextNode.getMessage((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)message, (String)"Missing Message", (Object[])new Object[0]);
        CSegmentId segmentId = message.getEnvelope().getReceiver().getSegmentId();
        if (CSegmentId.isLocal((CSegmentId)segmentId)) {
            this.getMessageSender().send(message);
        } else {
            CSegmentRoutingHint hint = this.mHints.findOne(segmentId);
            if (hint == null) {
                LOG.debug("No Hint found for: {}", new Object[]{segmentId});
                aEnvelope.setResult(5401, "No Hint found for SegmentId");
            } else {
                CNodeId remoteNode = hint.getLocalNode();
                LOG.debug("Forward Message to {}: msg = {}", new Object[]{remoteNode, message});
                CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)remoteNode);
                CRecord record = CRecordForwardMessage.create();
                CRecordForwardMessage.setMessage((CRecord)record, (CMessage)message);
                this.send(env, record);
                aEnvelope.setResultSuccess();
            }
        }
        return true;
    }

    private boolean asyncGetNextHop(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSegmentId destination = CRecordLinkCollectorGetNextHop.getDestination((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)destination, (String)"Missing Destination", (Object[])new Object[0]);
        CSegmentRoutingHint hint = this.mHints.findOne(destination);
        if (hint != null) {
            LOG.warn("Hint found: {}", new Object[]{hint});
            CRecordLinkCollectorGetNextHop.setHop((CRecord)aRecord, (CNodeId)hint.getLocalNode());
            aEnvelope.setResultSuccess();
        } else {
            LOG.warn("No hint found for {}", new Object[]{destination});
            aEnvelope.setResult(5401, "No Hint found");
        }
        return true;
    }

    private boolean asyncRemoveRoutingHint(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CSegmentId segment = CRecordLinkCollectorRemoveRoutingHint.getSegment((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)segment, (String)"Missing Segment ID", (Object[])new Object[0]);
        CNodeId nodeId = CRecordLinkCollectorRemoveRoutingHint.getRoutingNode((CRecord)aRecord, (CNodeId)aEnvelope.getSender().getNodeId());
        this.mHints.remove(segment, nodeId);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddLink(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node1 = CRecordLinkCollectorAddLink.getNode1((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node1, (String)"Missing Node 1", (Object[])new Object[0]);
        CNodeAddress node2 = CRecordLinkCollectorAddLink.getNode2((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node2, (String)"Missing Node 2", (Object[])new Object[0]);
        int costs = CRecordLinkCollectorAddLink.getCosts((CRecord)aRecord, (int)1);
        this.mLinks.add(new CLink(node1, node2, costs));
        CSegmentId segmentId1 = node1.getSegmentId();
        boolean local1 = segmentId1.isLocal();
        CSegmentId segmentId2 = node2.getSegmentId();
        boolean local2 = segmentId2.isLocal();
        if (!local1 && local2) {
            this.mHints.add(new CSegmentRoutingHint(segmentId1, node2.getNodeId()));
        }
        if (local1 && !local2) {
            this.mHints.add(new CSegmentRoutingHint(segmentId2, node1.getNodeId()));
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveLink(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node1 = CRecordLinkCollectorRemoveLink.getNode1((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node1, (String)"Missing node 1", (Object[])new Object[0]);
        CNodeAddress node2 = CRecordLinkCollectorRemoveLink.getNode2((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)node2, (String)"Missing node 2", (Object[])new Object[0]);
        aEnvelope.setResultSuccess();
        this.mLinks.remove(new CLink(node1, node2, 1));
        CSegmentId segmentId1 = node1.getSegmentId();
        boolean local1 = segmentId1.isLocal();
        CSegmentId segmentId2 = node2.getSegmentId();
        boolean local2 = segmentId2.isLocal();
        if (!local1 && local2) {
            this.mHints.remove(segmentId1, node2.getNodeId());
        }
        if (local1 && !local2) {
            this.mHints.remove(segmentId2, node1.getNodeId());
        }
        return true;
    }

    private boolean asyncSyncLinks(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = aEnvelope.getSender().getNodeAddress();
        CUtilCheck.checkNotNull((Object)node, (String)"Missing Sender", (Object[])new Object[0]);
        CNodeAddress[] remoteNodes = CRecordLinkCollectorSyncLinks.getRemoteNodes((CRecord)aRecord, null);
        int[] costs = CRecordLinkCollectorSyncLinks.getCosts((CRecord)aRecord, null);
        if (remoteNodes == null || remoteNodes.length == 0) {
            this.mLinks.removeNode(node);
            this.mHints.removeNode(node);
        } else {
            this.mLinks.syncNode(node, remoteNodes, costs);
            this.mHints.syncNode(node, remoteNodes);
        }
        aEnvelope.setResultSuccess();
        return true;
    }
}

