/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyAppInstanceStarted
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"f2be95a8-50a5-4a42-a1f3-53eb3a02145d");
    public static final String NAME = "NotifyAppInstanceStarted";
    public static final String DESCRIPTION = "Whenever an application instance has been started, this notification service will be triggered. Direction: App Instance Registry --> Public.";
    public static final String SLOT_INSTANCE = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CRecord getInstance(@NotNull CRecord aRecord, CRecord aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord)slot.getValue();
    }

    public static void setInstance(@NotNull CRecord aRecord, CRecord aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE, slot);
    }
}

