/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordAppGetSupportedApplications
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"d8e7cf50-3d1c-4edc-abac-1a36a8d98bc6");
    public static final String NAME = "AppGetSupportedApplications";
    public static final String DESCRIPTION = "Get the list of supported applications. Direction: App Registry --> Public.";
    public static final String SLOT_APPLICATIONS = "1";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CRecord[] getApplications(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_APPLICATIONS);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static void setApplications(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_APPLICATIONS, slot);
    }
}

