/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.app;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.EAppInstanceStatus;
import de.sillysky.nyssr.app.IApplicationInstance;
import de.sillysky.nyssr.app.records.CRecordDataApplicationInstance;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilEnum;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.time.LocalDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CApplicationInstance
implements IApplicationInstance {
    private final long mActivityCounter;
    private final UUID mInstanceID;
    private final IId mNID;
    private final CNodeAddress mNodeAddress;
    private final LocalDateTime mTimeStarted;
    private final CNodeAddress mRemoteSkinClientNode;
    private final String mSessionToken;
    private final String mUserId;
    private final UUID mApplicationId;
    private final String mApplicationName;
    private final String mApplicationDescription1;
    private final String mApplicationDescription2;
    private final String mApplicationIconPath;
    private final String mPresetName;
    private final CStringProperties mProperties;
    private final CTargetAddress mAddress;
    private final EAppInstanceStatus mStatus;

    public CApplicationInstance(@NotNull UUID aApplicationId, @NotNull String aApplicationName, @NotNull String aApplicationDescription1, @NotNull String aApplicationDescription2, @NotNull String aApplicationIconPath, @NotNull String aPresetName, @NotNull CStringProperties aProperties, @NotNull UUID aInstanceID, @NotNull IId aNID, @NotNull CNodeAddress aNodeAddress, @NotNull LocalDateTime aTimeStarted, @Nullable CNodeAddress aRemoteSkinClientNode, @NotNull CTargetAddress aInstanceAddress, long aActivityCounter, @NotNull EAppInstanceStatus aStatus, @NotNull String aSessionToken, @NotNull String aUserId) {
        this.mApplicationId = aApplicationId;
        this.mApplicationName = aApplicationName;
        this.mApplicationDescription1 = aApplicationDescription1;
        this.mApplicationDescription2 = aApplicationDescription2;
        this.mApplicationIconPath = aApplicationIconPath;
        this.mPresetName = aPresetName;
        this.mProperties = aProperties;
        this.mInstanceID = aInstanceID;
        this.mNID = aNID;
        this.mNodeAddress = aNodeAddress;
        this.mTimeStarted = aTimeStarted;
        this.mStatus = aStatus;
        this.mRemoteSkinClientNode = aRemoteSkinClientNode;
        this.mActivityCounter = aActivityCounter;
        this.mAddress = aInstanceAddress;
        this.mSessionToken = aSessionToken;
        this.mUserId = aUserId;
    }

    public static CApplicationInstance create(@NotNull CRecord aRecord) {
        CTargetAddress instanceAddress;
        CUtilCheck.checkNotNull((Object)aRecord, (String)"Record is null", (Object[])new Object[0]);
        CUtilCheck.checkEqual((Object)aRecord.getId(), (Object)CRecordDataApplicationInstance.ID, (String)"Wrong record type: this is not a %s", (Object[])new Object[]{CRecordDataApplicationInstance.class.getSimpleName()});
        UUID applicationId = CRecordDataApplicationInstance.getApplicationId(aRecord, null);
        String name = CRecordDataApplicationInstance.getApplicationName(aRecord, "");
        String description1 = CRecordDataApplicationInstance.getApplicationDescription1(aRecord, "");
        String description2 = CRecordDataApplicationInstance.getApplicationDescription2(aRecord, "");
        String iconPath = CRecordDataApplicationInstance.getApplicationIcon(aRecord, "");
        String presetName = CRecordDataApplicationInstance.getPresetName(aRecord, null);
        CStringProperties properties = CRecordDataApplicationInstance.getPresetProperties(aRecord, null);
        if (properties == null) {
            properties = new CStringProperties();
        }
        UUID instanceId = CRecordDataApplicationInstance.getInstanceId(aRecord, null);
        IId nid = CRecordDataApplicationInstance.getInstanceNid(aRecord, null);
        long activityCounter = CRecordDataApplicationInstance.getInstanceActivityCounter(aRecord, 0L);
        CNodeAddress instanceNode = CRecordDataApplicationInstance.getInstanceNode(aRecord, null);
        LocalDateTime instanceTimeStarted = CRecordDataApplicationInstance.getInstanceTimeStarted(aRecord, null);
        if (instanceTimeStarted == null) {
            instanceTimeStarted = LocalDateTime.now();
        }
        if ((instanceAddress = CRecordDataApplicationInstance.getInstanceAddress(aRecord, null)) == null) {
            instanceAddress = new CTargetAddress(IId.INVALID, nid, instanceNode);
        }
        CNodeAddress remoteSkinClientNode = CRecordDataApplicationInstance.getRemoteSkinClientNode(aRecord, null);
        String paramStatus = CRecordDataApplicationInstance.getInstanceStatus(aRecord, null);
        EAppInstanceStatus status = (EAppInstanceStatus)((Object)CUtilEnum.fromString(EAppInstanceStatus.class, (String)paramStatus, (Object)((Object)EAppInstanceStatus.UNKNOWN)));
        String sessionToken = CRecordDataApplicationInstance.getSessionToken(aRecord, null);
        String userId = CRecordDataApplicationInstance.getUserId(aRecord, "");
        if (applicationId != null && CUtilString.isValid((String)name) && CUtilString.isValid((String)presetName) && instanceId != null && nid != null && instanceNode != null && sessionToken != null) {
            return new CApplicationInstance(applicationId, name, description1, description2, iconPath, presetName, properties, instanceId, nid, instanceNode, instanceTimeStarted, remoteSkinClientNode, instanceAddress, activityCounter, status, sessionToken, userId);
        }
        return null;
    }

    @Override
    public long getActivityCounter() {
        return this.mActivityCounter;
    }

    @NotNull
    public CTargetAddress getAddress() {
        return this.mAddress;
    }

    @Override
    public CTargetAddress getTargetAddress() {
        return this.mAddress;
    }

    @Override
    @NotNull
    public String getShortDescription() {
        return this.mApplicationDescription1;
    }

    @Override
    @NotNull
    public String getLongDescription() {
        return this.mApplicationDescription2;
    }

    @Override
    @NotNull
    public String getIconPath() {
        return this.mApplicationIconPath;
    }

    @Override
    @NotNull
    public UUID getApplicationId() {
        return this.mApplicationId;
    }

    @Override
    @NotNull
    public String getApplicationName() {
        return this.mApplicationName;
    }

    @Override
    public UUID getInstanceId() {
        return this.mInstanceID;
    }

    @Override
    public IId getNID() {
        return this.mNID;
    }

    @Override
    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mNodeAddress;
    }

    @Override
    @NotNull
    public String getPresetName() {
        return this.mPresetName;
    }

    private CStringProperties getPrivateProperties() {
        CStringProperties pub = new CStringProperties();
        this.mProperties.getKeys().forEach(key -> {
            String lower = key.toLowerCase();
            if (!lower.contains("private") && !lower.contains("password")) {
                pub.put(key, this.mProperties.get(key));
            }
        });
        return pub;
    }

    @Override
    @NotNull
    public CStringProperties getPresetProperties() {
        return this.mProperties;
    }

    @Override
    @NotNull
    public EAppInstanceStatus getStatus() {
        return this.mStatus;
    }

    @Override
    @NotNull
    public LocalDateTime getTimeStarted() {
        return this.mTimeStarted;
    }

    @Override
    @NotNull
    public CRecord toRecord() throws CException {
        CRecord rec1 = CRecordDataApplicationInstance.create();
        CRecordDataApplicationInstance.setApplicationId(rec1, this.mApplicationId);
        CRecordDataApplicationInstance.setApplicationName(rec1, this.mApplicationName);
        CRecordDataApplicationInstance.setApplicationDescription1(rec1, this.mApplicationDescription1);
        CRecordDataApplicationInstance.setApplicationDescription2(rec1, this.mApplicationDescription2);
        CRecordDataApplicationInstance.setApplicationIcon(rec1, this.mApplicationIconPath);
        CRecordDataApplicationInstance.setPresetName(rec1, this.mPresetName);
        CRecordDataApplicationInstance.setPresetProperties(rec1, this.getPrivateProperties());
        CRecordDataApplicationInstance.setInstanceActivityCounter(rec1, this.getActivityCounter());
        CRecordDataApplicationInstance.setInstanceAddress(rec1, this.mAddress);
        CRecordDataApplicationInstance.setInstanceId(rec1, this.mInstanceID);
        CRecordDataApplicationInstance.setInstanceNid(rec1, this.mNID);
        CRecordDataApplicationInstance.setInstanceNode(rec1, this.mNodeAddress);
        CRecordDataApplicationInstance.setInstanceStatus(rec1, this.mStatus.name());
        CRecordDataApplicationInstance.setInstanceTimeStarted(rec1, this.mTimeStarted);
        CRecordDataApplicationInstance.setRemoteSkinClientNode(rec1, this.mRemoteSkinClientNode);
        CRecordDataApplicationInstance.setSessionToken(rec1, this.mSessionToken);
        CRecordDataApplicationInstance.setUserId(rec1, this.mUserId);
        return rec1;
    }

    @Override
    @Nullable
    public CNodeAddress getRemoteSkinClientNode() {
        return this.mRemoteSkinClientNode;
    }

    @Override
    @NotNull
    public String getSessionToken() {
        return this.mSessionToken;
    }

    @NotNull
    public String getUserId() {
        return this.mUserId;
    }
}

