/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.target1;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.microservice.registry.EListenerType;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordAddMicroServiceListener;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordNotifyMicroServiceInstanceAdded;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordNotifyMicroServiceInstanceRemoved;
import de.sillysky.nyssr.impl.microservice.registry.records.CRecordRemoveMicroServiceListener;
import de.sillysky.nyssr.impl.microservice.registry.service.CMicroServiceEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.CMicroServiceInstanceEntry;
import de.sillysky.nyssr.impl.microservice.registry.service.IMicroServiceObserver;
import de.sillysky.nyssr.impl.microservice.registry.service.IMicroServiceRegistry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.message.CRoutingHint;
import de.sillysky.nyssr.microservice.collector.CMicroServiceDescription;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryCreated;
import de.sillysky.nyssr.microservice.registry.broadcast.records.CRecordBroadcastMicroServiceRegistryDeleted;
import de.sillysky.nyssr.microservice.registry.records.CRecordForwardToMicroServiceInstance;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServiceIds;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServiceInstance;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServiceInstances;
import de.sillysky.nyssr.microservice.registry.records.CRecordGetMicroServices;
import de.sillysky.nyssr.microservice.registry.records.CRecordRegisterMicroService;
import de.sillysky.nyssr.microservice.registry.records.CRecordRemoveMicroServiceInstance;
import de.sillysky.nyssr.namedb.INameDb;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.network.broadcast.IBroadcastService;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeAdded;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class CTargetMicroServiceRegistry
extends CTarget
implements IService,
IMicroServiceObserver {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetMicroServiceRegistry.class);
    private static final IId[] SIDS = new IId[]{CRecordGetMicroServiceInstances.ID, CRecordGetMicroServiceIds.ID, CRecordGetMicroServices.ID, CRecordRegisterMicroService.ID};
    private IMicroServiceRegistry mRegistry;
    private INamespace mNamespace;
    private IRecordHelper mRecordHelper;
    private IBroadcastService mBroadcastService;
    private INameDb mNameDb;

    public CTargetMicroServiceRegistry() {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordRemoveMicroServiceInstance.ID, this::asyncRemoveMicroServiceInstance);
        this.addMessageHandler(CRecordForwardToMicroServiceInstance.ID, this::asyncForwardToMicroServiceInstance);
        this.addMessageHandler(CRecordGetMicroServiceInstance.ID, this::asyncGetMicroServiceInstance);
        this.addMessageHandler(CRecordGetMicroServiceInstances.ID, this::asyncGetMicroServiceInstances);
        this.addMessageHandler(CRecordGetMicroServiceIds.ID, this::asyncGetMicroServiceIds);
        this.addMessageHandler(CRecordGetMicroServices.ID, this::asyncGetMicroServices);
        this.addMessageHandler(CRecordRegisterMicroService.ID, this::asyncRegisterMicroServices);
        this.addMessageHandler(CRecordNotifyRemoteNodeAdded.ID, this::asyncNotifyRemoteNodeAdded);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        this.addMessageHandler(CRecordAddMicroServiceListener.ID, this::asyncAddListener);
        this.addMessageHandler(CRecordRemoveMicroServiceListener.ID, this::asyncRemoveListener);
        this.addMessageHandler(null, this::asyncAllOtherMessages);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        LOG.info("Start: MicroServiceRegistry");
        this.mRegistry = (IMicroServiceRegistry)aServiceRegistry.getServiceOrThrow(IMicroServiceRegistry.class);
        this.mRegistry.setListenerInformer(this);
        this.mNameDb = (INameDb)aServiceRegistry.getService(INameDb.class);
        this.mRecordHelper = (IRecordHelper)aServiceRegistry.getServiceOrThrow(IRecordHelper.class);
        this.mBroadcastService = (IBroadcastService)aServiceRegistry.getServiceOrThrow(IBroadcastService.class);
        INamespaceFactory nsf = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        IId nid = CIdFactory.random((String)"MicroServiceReg");
        this.mNamespace = nsf.createAndRegisterNamespace(nid, "MicroServiceReg");
        this.mNamespace.getTargetRegistry().registerTarget((ITarget)this);
        LOG.info("Okay: MicroServiceRegistry started");
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        LOG.info("Try to stop MicroServiceRegistry");
        this.broadcastRegistryDeleted();
        this.deregisterTarget();
        LOG.info("Okay: MicroServiceRegistry stopped");
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        INanoServiceRegistry nanoServiceRegistry = this.mNamespace.getNanoServiceRegistry();
        nanoServiceRegistry.addObservers(SIDS, this.getAddress());
        this.mRecordHelper.addObserver(CRecordNotifyRemoteNodeAdded.class, (ITarget)this, true);
        this.mRecordHelper.addObserver(CRecordNotifyRemoteNodeRemoved.class, (ITarget)this, true);
        this.broadcastRegistryCreated();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAllOtherMessages(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        IId id = aEnvelope.getMicroServiceId();
        if (CIdFactory.isValid((IId)id)) {
            CTargetAddress address = this.mRegistry.getRandomInstance(id);
            if (address == null) {
                if (LOG.isWarnEnabled()) {
                    String recordIdString = this.getRecordIdName(aRecord);
                    LOG.warn("Couldn't forward Message {} to id = {} (no micro service found)", new Object[]{recordIdString, id});
                }
                aEnvelope.setResult(2302, "MicroService not found");
                this.getMessageSender().sendBack(aEnvelope, aRecord);
            } else {
                if (LOG.isDebugEnabled()) {
                    String recordIdString = this.getRecordIdName(aRecord);
                    LOG.debug("Forward Message {} to: id = {}, target = {}", new Object[]{recordIdString, id, address});
                }
                aEnvelope.forwardMessage(address);
                aEnvelope.setPacketBuilderSequence("M");
                CRoutingHint routingHint = aEnvelope.getRoutingHint();
                if (routingHint != null) {
                    aEnvelope.setRoutingHint(routingHint);
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncRemoveMicroServiceInstance(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId id = CRecordRemoveMicroServiceInstance.getMicroServiceId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)id, (String)"Missing Micro Service ID", (Object[])new Object[0]);
        IId instanceId = CRecordRemoveMicroServiceInstance.getMicroServiceInstanceId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)instanceId, (String)"Missing Micro Service Instance ID", (Object[])new Object[0]);
        this.mRegistry.removeMicroService(id, instanceId, true);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncForwardToMicroServiceInstance(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CMessage message = CRecordForwardToMicroServiceInstance.getMessage((CRecord)aRecord, null);
        CEnvelope envelope = message.getEnvelope();
        CUtilCheck.checkNotNull((Object)message, (String)"Message is null", (Object[])new Object[0]);
        IId id = CRecordForwardToMicroServiceInstance.getMicroServiceId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)id, (String)"Micro Service ID is null", (Object[])new Object[0]);
        LOG.debug("Forward Message to {}", new Object[]{id});
        CTargetAddress address = this.mRegistry.getRandomInstance(id);
        if (address == null) {
            if (LOG.isWarnEnabled()) {
                String recordIdString = this.getRecordIdName(aRecord);
                LOG.warn("Couldn't forward Message {} to id = {} (no micro service found)", new Object[]{recordIdString, id});
            }
            aEnvelope.setResult(2302, "MicroService not found");
            envelope.setResult(2302, "MicroService not found");
            envelope.setReceiver(this.getAddress());
            this.getMessageSender().sendBack(message);
        } else {
            if (LOG.isDebugEnabled()) {
                String recordIdString = this.getRecordIdName(aRecord);
                LOG.debug("Forward Message {} to: id = {}, target = {}", new Object[]{recordIdString, id, address});
            }
            aRecord.removeSlot("1");
            envelope.setReceiver(address);
            envelope.setPacketBuilderSequence("M");
            CRoutingHint routingHint = aEnvelope.getRoutingHint();
            if (routingHint != null) {
                envelope.setRoutingHint(routingHint);
            }
            this.getMessageSender().send(message);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncGetMicroServiceIds(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId[] ids = this.mRegistry.getMicroServiceIds();
        CRecordGetMicroServiceIds.setMicroServiceIds((CRecord)aRecord, (IId[])ids);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetMicroServiceInstance(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId id = CRecordGetMicroServiceInstance.getMicroServiceId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)id, (String)"ID is empty", (Object[])new Object[0]);
        CTargetAddress address = this.mRegistry.getRandomInstance(id);
        if (address == null) {
            aEnvelope.setResult(5, "No instance found");
        } else {
            CRecordGetMicroServiceInstance.setOwner((CRecord)aRecord, (CTargetAddress)address);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncGetMicroServiceInstances(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId[] ids = CRecordGetMicroServiceInstances.getMicroServiceIds((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)ids, (String)"IDs are null", (Object[])new Object[0]);
        CUtilCheck.checkTrue((ids.length > 0 ? 1 : 0) != 0, (String)"ID is empty", (Object[])new Object[0]);
        ArrayList<CRecord> list = new ArrayList<CRecord>();
        for (IId id : ids) {
            CMicroServiceEntry microService = this.mRegistry.getMicroService(id);
            if (microService == null) continue;
            List<CMicroServiceInstanceEntry> instances = microService.getInstances();
            for (CMicroServiceInstanceEntry instance : instances) {
                list.add(instance.toRecord());
            }
        }
        CRecord[] instanceRecords = list.toArray(new CRecord[0]);
        CRecordGetMicroServiceInstances.setMicroServiceInstances((CRecord)aRecord, (CRecord[])instanceRecords);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetMicroServices(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        Collection<CMicroServiceDescription> descList = this.mRegistry.getMicroServices();
        CRecord[] arr = new CRecord[descList.size()];
        int i = 0;
        for (CMicroServiceDescription desc : descList) {
            arr[i++] = this.toRecord(desc);
        }
        CRecordGetMicroServices.setMicroServices((CRecord)aRecord, (CRecord[])arr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeAdded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeAdded.getRemoteNode((CRecord)aRecord, null);
        if (node != null) {
            LOG.debug("Node added: {}", new Object[]{node});
            this.sendRegistryCreated(node);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(8, "Missing NodeId");
        }
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CNodeAddress node = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
        if (node != null) {
            LOG.debug("Node removed: {}", new Object[]{node});
            this.mRegistry.notifyNodeDeleted(node);
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(8, "Missing NodeId");
        }
        return true;
    }

    private boolean asyncRegisterMicroServices(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord record = CRecordRegisterMicroService.getMicroService((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)record, (String)"Missing MicroService description", (Object[])new Object[0]);
        CMicroServiceDescription ms = this.fromRecord(record);
        IId instanceId = CRecordRegisterMicroService.getInstanceId((CRecord)aRecord, null);
        CTargetAddress address = CRecordRegisterMicroService.getAddress((CRecord)aRecord, (CTargetAddress)aEnvelope.getSender());
        if (instanceId == null || !instanceId.isValid()) {
            this.mRegistry.addMicroService(ms);
        } else {
            this.mRegistry.addMicroService(instanceId, address, ms, true);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddListener(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId msId = CRecordAddMicroServiceListener.getMicroServiceId(aRecord, null);
        CUtilCheck.checkNotNull((Object)msId, (String)"MicroService ID missing", (Object[])new Object[0]);
        int typeInt = CRecordAddMicroServiceListener.getListenerType(aRecord, 1);
        EListenerType type = EListenerType.fromInt(typeInt);
        CTargetAddress address = CRecordAddMicroServiceListener.getAddress(aRecord, aEnvelope.getSender());
        this.mRegistry.addListener(msId, address, type);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveListener(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        IId msId = CRecordRemoveMicroServiceListener.getMicroServiceId(aRecord, null);
        CUtilCheck.checkNotNull((Object)msId, (String)"MicroService ID missing", (Object[])new Object[0]);
        CTargetAddress address = CRecordAddMicroServiceListener.getAddress(aRecord, aEnvelope.getSender());
        this.mRegistry.removeListener(msId, address);
        aEnvelope.setResultSuccess();
        return true;
    }

    private void broadcastRegistryCreated() throws CException {
        LOG.debug("Send Broadcast: MicroServiceRegistryCreated");
        CTargetAddress address = this.getAddress();
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordBroadcastMicroServiceRegistryCreated.class);
        env.setSender(address);
        CRecord rec = CRecordBroadcastMicroServiceRegistryCreated.create();
        CRecordBroadcastMicroServiceRegistryCreated.setMicroServiceAddress((CRecord)rec, (CTargetAddress)address);
        this.mBroadcastService.broadcastMessage(env, rec, true);
    }

    private void broadcastRegistryDeleted() throws CException {
        LOG.debug("Send Broadcast: MicroServiceRegistryDeleted");
        CTargetAddress address = this.getAddress();
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordBroadcastMicroServiceRegistryDeleted.class);
        env.setSender(address);
        CRecord rec = CRecordBroadcastMicroServiceRegistryDeleted.create();
        CRecordBroadcastMicroServiceRegistryDeleted.setMicroServiceAddress((CRecord)rec, (CTargetAddress)address);
        this.mBroadcastService.broadcastMessage(env, rec, true);
    }

    @NotNull
    private CMicroServiceDescription fromRecord(@NotNull CRecord aRecord) throws CException {
        return CMicroServiceDescription.fromRecord((CRecord)aRecord);
    }

    private void sendRegistryCreated(@NotNull CNodeAddress aNode) throws CException {
        LOG.debug("Send NotifyMicroServiceRegistryCreated directly to {}", new Object[]{aNode});
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordBroadcastMicroServiceRegistryCreated.class, (CNodeAddress)aNode);
        CRecord rec = CRecordBroadcastMicroServiceRegistryCreated.create();
        CRecordBroadcastMicroServiceRegistryCreated.setMicroServiceAddress((CRecord)rec, (CTargetAddress)this.getAddress());
        this.sendNotification(env, rec);
    }

    private CRecord toRecord(@NotNull CMicroServiceDescription aDesc) throws CException {
        return aDesc.valueToRecord();
    }

    @Override
    public void notifyMicroServiceAdded(@NotNull CMicroServiceDescription aDesc, @NotNull CTargetAddress aAddress) {
        try {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddress);
            CRecord record = CRecordNotifyMicroServiceInstanceAdded.create();
            CRecord descRecord = aDesc.valueToRecord();
            CRecordNotifyMicroServiceInstanceAdded.setMicroService(record, descRecord);
            this.sendNotification(env, record);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error sending notification");
        }
    }

    @Override
    public void notifyMicroServiceRemoved(@NotNull IId aId, @NotNull CTargetAddress aAddress) {
        try {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddress);
            CRecord record = CRecordNotifyMicroServiceInstanceRemoved.create();
            CRecordNotifyMicroServiceInstanceRemoved.setMicroServiceId(record, aId);
            this.sendNotification(env, record);
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error sending notification");
        }
    }

    private String getRecordIdName(@NotNull CRecord aRecord) {
        IId id = aRecord.getId();
        String recordIdString = this.mNameDb != null ? this.mNameDb.getRecordIdDatabase().getName(id) : id.toShortString();
        return recordIdString;
    }
}

