/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.router.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkLinkData
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"bd91d9eb-b64a-47ef-b16e-78db6d80674b");
    public static final String NAME = "NetworkLinkData";
    public static final String DESCRIPTION = "Data record: A node link.";
    public static final String SLOT_CONNECTION_ID = "1";
    public static final String SLOT_COSTS = "4";
    public static final String SLOT_COST_MEASURE_TIME = "5";
    public static final String SLOT_NODE1 = "2";
    public static final String SLOT_NODE2 = "3";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getConnectionId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static int getCosts(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COSTS);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static ZonedDateTime getCostMeasureTime(@NotNull CRecord aRecord, ZonedDateTime aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COST_MEASURE_TIME);
        if (slot == null) {
            return aDefault;
        }
        return (ZonedDateTime)slot.getValue();
    }

    public static CNodeAddress getNode1(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE1);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static CNodeAddress getNode2(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE2);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static void setConnectionId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_ID, slot);
    }

    public static void setCosts(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_COSTS, slot);
    }

    public static void setCostMeasureTime(@NotNull CRecord aRecord, ZonedDateTime aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ZONED_DATE_TIME, (Object)aValue);
        aRecord.addSlot(SLOT_COST_MEASURE_TIME, slot);
    }

    public static void setNode1(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_NODE1, slot);
    }

    public static void setNode2(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_NODE2, slot);
    }
}

