/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.app.usermanager;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.app.usermanager.CRecordMainFinished;
import de.sillysky.nyssr.impl.web.app.usermanager.ILocalAppContext;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordShowWebDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebDismissDialog;
import de.sillysky.nyssr.remoteskin.web.dialog.records.CRecordWebNotifyDialogDismissed;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebApi;
import de.sillysky.nyssr.remoteskin.web.protocol.CWebDialogApi;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class C00300UserManager
extends CTarget {
    private static final IId MICRO_SERVICE_USER_LIST = CIdFactory.fromObject((Object)"NY_WebDialogUserList_00310");
    private static final IId MICRO_SERVICE_ROLE_LIST = CIdFactory.fromObject((Object)"NY_WebDialogRoleList_00311");
    private static final IId MICRO_SERVICE_RIGHT_LIST = CIdFactory.fromObject((Object)"NY_WebDialogRightList_00312");
    private static final String ID_TAB_USER = "id_00300_tab_user";
    private static final String ID_TAB_ROLES = "id_00300_tab_roles";
    private static final String ID_TAB_RIGHTS = "id_00300_tab_rights";
    private final ILocalAppContext mLocalAppContext;
    private final String mMainWidgetId;
    private CWebApi mWebApi;
    private CWebDialogApi mWebDialogApi;
    private final Map<IId, CTargetAddress> mRunningMicroServices = new HashMap<IId, CTargetAddress>(10);

    C00300UserManager(@NotNull ILocalAppContext aLocalAppContext, @NotNull String aMainWidgetId) {
        this.mLocalAppContext = aLocalAppContext;
        this.mMainWidgetId = aMainWidgetId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordShowWebDialog.ID, this::asyncShowWebDialog);
        this.addMessageHandler(CRecordWebNotifyDialogDismissed.ID, this::asyncWebDialogFinished);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.mWebApi = new CWebApi((ITarget)this, this.mLocalAppContext.getApplicationContext().getClientRemoteSkinAddress());
        this.mWebDialogApi = new CWebDialogApi((ITarget)this, this.mLocalAppContext.getApplicationContext().getClientRemoteSkinAddress());
        this.showDialog();
        this.sendShowUserList();
        this.sendShowRoleList();
        this.sendShowRightList();
        aEnvelope.setResultSuccess();
        return true;
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00300_main.html");
        this.mWebApi.setInnerHtml(this.mMainWidgetId, main);
    }

    private boolean asyncShowWebDialog(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 5108) {
                this.sendFinished();
            } else if (resultCode == 0) {
                CTargetAddress address = CRecordShowWebDialog.getDialogTargetAddress((CRecord)aRecord, null);
                IId microServiceId = aEnvelope.getMicroServiceId();
                this.mRunningMicroServices.put(microServiceId, address);
            }
            return true;
        }
        return false;
    }

    private boolean asyncWebDialogFinished(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendFinished();
        aEnvelope.setResultSuccess();
        return true;
    }

    private void sendShowUserList() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_USER_LIST, this.mLocalAppContext.getSessionToken(), ID_TAB_USER, null);
    }

    private void sendShowRoleList() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_ROLE_LIST, this.mLocalAppContext.getSessionToken(), ID_TAB_ROLES, null);
    }

    private void sendShowRightList() throws CException {
        this.mWebDialogApi.showWebDialog(MICRO_SERVICE_RIGHT_LIST, this.mLocalAppContext.getSessionToken(), ID_TAB_RIGHTS, null);
    }

    private void sendFinished() throws CException {
        for (CTargetAddress address : this.mRunningMicroServices.values()) {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)address);
            CRecord record = CRecordWebDismissDialog.create();
            this.sendNotification(env, record);
        }
        CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)this.mLocalAppContext.getApplicationContext().getApplicationAddress());
        CRecord record = CRecordMainFinished.create();
        this.sendNotification(env, record);
        this.mWebApi.deregisterWidgetOwner();
        this.deregisterTarget();
    }

    public void deactivate() throws CException {
        this.sendFinished();
    }
}

