/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.webserver.ssl;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class CStaticFileHandler
implements HttpHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CStaticFileHandler.class);
    private static final Map<String, String> MIME_TYPES = new HashMap<String, String>();
    private final Path mWebRootPath;

    CStaticFileHandler(@NotNull Path aWebRootPath) {
        this.mWebRootPath = aWebRootPath;
    }

    @Override
    public synchronized void handle(@NotNull HttpExchange aExchange) throws IOException {
        Path filePath;
        String uri = aExchange.getRequestURI().getPath();
        System.out.print(uri);
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        if (Files.exists(filePath = this.mWebRootPath.resolve(uri), new LinkOption[0]) && !Files.isDirectory(filePath, new LinkOption[0])) {
            String fileExtension = this.getFileExtension(filePath.getFileName().toString());
            String mimeType = MIME_TYPES.getOrDefault(fileExtension, "application/octet-stream");
            byte[] fileBytes = Files.readAllBytes(filePath);
            aExchange.getResponseHeaders().set("Content-Type", mimeType);
            aExchange.sendResponseHeaders(200, fileBytes.length);
            OutputStream os = aExchange.getResponseBody();
            os.write(fileBytes);
            os.close();
            LOG.debug("Download successfully: " + uri);
            System.out.println("  done");
        } else {
            String response = "404 (Not Found)\n";
            aExchange.sendResponseHeaders(404, "404 (Not Found)\n".length());
            OutputStream os = aExchange.getResponseBody();
            os.write("404 (Not Found)\n".getBytes());
            os.close();
            LOG.warn("Download not found: " + uri);
        }
    }

    @NotNull
    private String getFileExtension(@NotNull String aFileName) {
        int lastDotIndex = aFileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < aFileName.length() - 1) {
            return aFileName.substring(lastDotIndex + 1).toLowerCase();
        }
        return "";
    }

    static {
        MIME_TYPES.put("html", "text/html");
        MIME_TYPES.put("css", "text/css");
        MIME_TYPES.put("js", "application/javascript");
        MIME_TYPES.put("png", "image/png");
        MIME_TYPES.put("jpg", "image/jpeg");
        MIME_TYPES.put("jpeg", "image/jpeg");
        MIME_TYPES.put("gif", "image/gif");
        MIME_TYPES.put("svg", "image/svg+xml");
        MIME_TYPES.put("txt", "text/plain");
    }
}

