/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.widget.showcase.progressbar;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.app.widget.showcase.progressbar.CProgressBarModel;
import de.sillysky.nyssr.remoteskin.model.enums.EWidgetOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventInteger;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IIntegerListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import org.jetbrains.annotations.NotNull;

public class CProgressBarUi {
    private final CProgressBarModel mModel;
    private final IRemoteSkinServerContext mServerContext;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs314;
    private final CWidgetId mProgress002;
    private final CWidgetId mProgress003;
    private final CWidgetId mProgress004;
    private final CWidgetId mProgress005;
    private final CWidgetId mProgress006;
    private CWidgetId m314PanelMain;

    public CProgressBarUi(@NotNull CProgressBarModel aModel) {
        this.mModel = aModel;
        this.mServerContext = aModel.getAppContext().getRemoteSkinServerContext();
        this.mApi = this.mServerContext.getWidgetApi();
        String instance = this.mModel.getParent().getWidgetSetId().getInstance();
        this.mWs314 = CWidgetSetId.create((String)"@314_ProgressBar", (String)instance);
        this.mProgress002 = CWidgetId.create((String)"#314_Component_002", (CWidgetSetId)this.mWs314);
        CWidgetId checkBox002 = CWidgetId.create((String)"#314_Helper_002", (CWidgetSetId)this.mWs314);
        this.mApi.addListener(checkBox002, (IListener)((IButtonPressedListener)this::onCheckbox002));
        this.mProgress003 = CWidgetId.create((String)"#314_Component_003", (CWidgetSetId)this.mWs314);
        CWidgetId checkBox003 = CWidgetId.create((String)"#314_Helper_003", (CWidgetSetId)this.mWs314);
        this.mApi.addListener(checkBox003, (IListener)((IButtonPressedListener)this::onCheckbox003));
        this.mProgress004 = CWidgetId.create((String)"#314_Component_004", (CWidgetSetId)this.mWs314);
        CWidgetId checkBox004 = CWidgetId.create((String)"#314_Helper_004", (CWidgetSetId)this.mWs314);
        this.mApi.addListener(checkBox004, (IListener)((IButtonPressedListener)this::onCheckbox004));
        this.mProgress005 = CWidgetId.create((String)"#314_Component_005", (CWidgetSetId)this.mWs314);
        CWidgetId slider005 = CWidgetId.create((String)"#314_Helper_005", (CWidgetSetId)this.mWs314);
        this.mApi.addListener(slider005, (IListener)((IIntegerListener)this::onSlider005));
        this.mProgress006 = CWidgetId.create((String)"#314_Component_006", (CWidgetSetId)this.mWs314);
        CWidgetId textField006 = CWidgetId.create((String)"#314_Helper_006", (CWidgetSetId)this.mWs314);
        this.mApi.addListener(textField006, (IListener)((ITextChangeListener)this::onTextField006));
    }

    private void onCheckbox002(@NotNull CEventButtonPressedNotification aEvent) {
        boolean painted = aEvent.isSelected();
        this.mApi.setBorderPainted(this.mProgress002, painted);
        this.mServerContext.sendUpdate();
    }

    private void onCheckbox003(@NotNull CEventButtonPressedNotification aEvent) {
        boolean enabled = aEvent.isSelected();
        this.mApi.setIndeterminateMode(this.mProgress003, enabled);
        this.mServerContext.sendUpdate();
    }

    private void onCheckbox004(@NotNull CEventButtonPressedNotification aEvent) {
        boolean enabled = aEvent.isSelected();
        this.mApi.setOrientation(this.mProgress004, enabled ? EWidgetOrientation.vertical : EWidgetOrientation.horizontal);
        this.mServerContext.sendUpdate();
    }

    private void onSlider005(@NotNull CEventInteger aEvent) {
        this.mApi.setValue(this.mProgress005, aEvent.getValue());
        this.mServerContext.sendUpdate();
    }

    private void onTextField006(@NotNull CEventTextChangeNotification aEvent) {
        CEventText event = new CEventText();
        event.setDefault(aEvent.getText());
        this.mApi.setText(this.mProgress006, event);
        this.mServerContext.sendUpdate();
    }

    private void widgetSet314Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        this.m314PanelMain = CWidgetId.create((String)"#314_Panel", (CWidgetSetId)this.mWs314);
        this.mApi.setVisible(this.m314PanelMain, true);
        this.mServerContext.sendUpdate();
        this.mModel.getAppContext().sendOtherWidgetSets();
    }

    void mountWidgetSet314() {
        this.mServerContext.mountWidgetSet(this.mWs314, this.mModel.getParent(), "#314_Panel", this::widgetSet314Mounted);
        this.mServerContext.sendUpdate();
    }

    public void dismiss() {
        this.mApi.unmount(this.m314PanelMain);
    }
}

