/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.remoteskin.client.context.CWidgetSetList;
import de.sillysky.nyssr.impl.remoteskin.client.context.CWidgetSetMounter;
import de.sillysky.nyssr.impl.remoteskin.client.context.IFactory;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CModelConstants;
import de.sillysky.nyssr.remoteskin.model.CRootWidgetList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EFileDeliveryType;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinPlatformContext;
import de.sillysky.nyssr.remoteskin.model.IWidgetFactory;
import de.sillysky.nyssr.remoteskin.model.IWidgetFactoryRegistry;
import de.sillysky.nyssr.remoteskin.model.command.CAttributeEntry;
import de.sillysky.nyssr.remoteskin.model.command.CListOfAttributes;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandFactory;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandParser;
import de.sillysky.nyssr.remoteskin.model.events.CEventCreateWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventGlobalProperties;
import de.sillysky.nyssr.remoteskin.model.events.CEventMountWidgetSet;
import de.sillysky.nyssr.remoteskin.model.events.CEventRemoveWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventUnmountWidget;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetSetId;
import de.sillysky.nyssr.remoteskin.model.events.layout.CEventLayoutConstraints;
import de.sillysky.nyssr.remoteskin.model.names.EPrivateWidgetNames;
import de.sillysky.nyssr.remoteskin.model.vars.IGlobalPropertyHolder;
import de.sillysky.nyssr.signal.properties.IPropertySignal;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.properties.hierarchical.CHierarchicalPropertyKey;
import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CRemoteSkinClientContext
implements IRemoteSkinClientContext {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinClientContext.class);
    private final CWidgetSetList mWidgetSetList = new CWidgetSetList();
    private final CRootWidgetList mRootWidgetList = new CRootWidgetList();
    private final List<Object> mPopupEvents = new ArrayList<Object>();
    private IId mId;
    private CTargetAddress mOwner;
    private IRemoteSkinPlatformContext mPlatformContext;
    private ITargetRegistry mTargetRegistry;
    private IFactory mPrivateContextFactory;
    private ITarget mTarget;

    CRemoteSkinClientContext() {
    }

    public void activate(@NotNull IFactory aPrivateContextFactory, @NotNull IId aId, @NotNull IRemoteSkinPlatformContext aPlatformContext, @Nullable CTargetAddress aOwner) {
        this.mPrivateContextFactory = aPrivateContextFactory;
        this.mId = aId;
        this.mPlatformContext = aPlatformContext;
        this.mOwner = aOwner;
        CStringProperties sp = new CStringProperties();
        sp.put("remoteskin.context.id", this.mId.valueToString());
        CServiceRegistry.getInstance().registerService(IRemoteSkinClientContext.class, sp, (Object)this);
    }

    public void addRootWidget(@NotNull CWidget aWidget) {
        this.mRootWidgetList.add(aWidget);
    }

    public void addWidgetSet(@NotNull CWidgetSet aWidgetSet) {
        this.mWidgetSetList.add(aWidgetSet);
    }

    public void deactivate() {
        LOG.info("Stop RemoteSkin {}", new Object[]{this.getId()});
        this.mRootWidgetList.disposeAll();
        CServiceRegistry.getInstance().deregisterService((Object)this);
    }

    @Nullable
    public CWidget findOrMountWidgetSet(@NotNull CWidget aParent, @NotNull CWidgetSetId aWidgetSetId) throws Exception {
        CWidgetSetMounter mounter;
        CWidgetSet widgetSet = this.mWidgetSetList.get(aWidgetSetId);
        if (widgetSet != null) {
            return widgetSet.getRootWidget();
        }
        CWidgetSet parentWidgetSet = aParent.getWidgetSet();
        widgetSet = this.mPrivateContextFactory.getRawWidgetSetList().createWidgetSet((IRemoteSkinClientContext)this, aWidgetSetId, aParent, parentWidgetSet.getOwnerAddress());
        if (widgetSet != null && (widgetSet = (mounter = new CWidgetSetMounter(this, this.mPrivateContextFactory.getRawWidgetSetList(), this.mWidgetSetList, this.mRootWidgetList)).mount(aParent.getId(), aWidgetSetId, parentWidgetSet.getOwnerAddress(), null)) != null) {
            return widgetSet.getRootWidget();
        }
        return null;
    }

    public CWidget findWidget(@Nullable CWidgetId aWidgetId) {
        if (aWidgetId == null) {
            return null;
        }
        return this.mWidgetSetList.findWidget(aWidgetId);
    }

    @NotNull
    public IId getId() {
        return this.mId;
    }

    public void requestFile(@NotNull String aRelativePath, @NotNull CWidgetId aRequester, @NotNull Object aToken, @NotNull EFileDeliveryType aFileDeliveryType) {
        IPropertySignalDispatcher sd = this.mPrivateContextFactory.getSystemSignalDispatcher();
        IPropertySignal signal = sd.createSignal(CUtilUuid.fromString((String)"c467035d-5c9b-4337-a5a8-b0826f104696"));
        signal.set("WidgetId", (Object)aRequester);
        signal.set("Path", (Object)aRelativePath);
        signal.set("Token", aToken);
        signal.set("FileDeliveryType", (Object)"AS_IMAGE");
        sd.signal(signal);
    }

    public CTargetAddress getOwner() {
        return this.mOwner;
    }

    @NotNull
    public IRemoteSkinPlatformContext getPlatformContext() {
        return this.mPlatformContext;
    }

    @NotNull
    public List<Object> getPopupEvents() {
        return this.mPopupEvents;
    }

    public ITargetRegistry getTargetRegistry() {
        return this.mTargetRegistry;
    }

    public void setTargetRegistry(ITargetRegistry aTargetRegistry) {
        this.mTargetRegistry = aTargetRegistry;
    }

    @NotNull
    public IWidgetFactoryRegistry getWidgetFactoryRegistry() {
        return this.mPrivateContextFactory.getWidgetFactoryRegistry();
    }

    public ITarget getTarget() {
        return this.mTarget;
    }

    public void setTarget(ITarget aTarget) {
        this.mTarget = aTarget;
    }

    public CWidgetSet mount(@Nullable CWidgetId aParent, @NotNull CWidgetSetId aWidgetSetIdToMount, @NotNull CTargetAddress aOwner, @Nullable UUID aTransactionId) throws Exception {
        CWidgetSetMounter mounter = new CWidgetSetMounter(this, this.mPrivateContextFactory.getRawWidgetSetList(), this.mWidgetSetList, this.mRootWidgetList);
        return mounter.mount(aParent, aWidgetSetIdToMount, aOwner, aTransactionId);
    }

    public void notifyWidgetUnmounted(@NotNull CWidget aWidget) {
        this.mRootWidgetList.remove(aWidget);
        this.mWidgetSetList.notifyWidgetUnmounted(aWidget);
    }

    private void setLookAndFeel(@NotNull CWidgetSet aWidgetSet) {
        CHierarchicalPropertyKey key = new CHierarchicalPropertyKey("lookandfeel");
        Object o = aWidgetSet.getProperties().get(key);
        if (o instanceof String) {
            this.mPlatformContext.setLookAndFeel((String)o);
        }
    }

    public void show(@NotNull CWidgetId aWidgetToShow) {
        CWidget w = this.findWidget(aWidgetToShow);
        if (w == null) {
            LOG.error("Could't show Widget {}: not found.", new Object[]{aWidgetToShow});
        } else {
            LOG.debug("Show Widget {}.", new Object[]{aWidgetToShow});
            this.mPlatformContext.invokeLater(() -> {
                w.show();
                w.getWidgetSet().notifyWidgets(ENotification.SHOWN, new Object[0]);
            });
        }
    }

    public void storeWidgetSet(String aJson) {
        if (CUtilString.isValid((String)aJson)) {
            try {
                this.mPrivateContextFactory.getRawWidgetSetList().addWidgetSet(aJson);
            }
            catch (CException aE) {
                LOG.error((Throwable)aE, "Couldn't parse WidgetSet");
            }
        }
    }

    public void unmountWidget(@Nullable CTargetAddress aSender, @NotNull CWidgetId aWidgetId) {
        LOG.debug("Unmount {}", new Object[]{aWidgetId});
        CWidget widget = this.findWidget(aWidgetId);
        if (widget != null) {
            widget.unmount();
            int rc = 0;
            CEventUnmountWidget ev = new CEventUnmountWidget(aWidgetId, rc);
            Object jo = ev.toJson();
            widget.getWidgetSet().addNotification(aWidgetId, "widgetUnmounted", jo);
            widget.getWidgetSet().sendNotifications();
        }
    }

    public IJsonCommandFactory getJsonCommandFactory() {
        return this.mPrivateContextFactory.getJsonCommandFactory();
    }

    public void notifyWidgetSetLoaded(@NotNull CWidgetSet aWidgetSet) {
        CWidgetSetId id = aWidgetSet.getId();
        CEventWidgetSetId event = new CEventWidgetSetId(id);
        aWidgetSet.addNotification(CWidgetId.create((String)EPrivateWidgetNames.widgetSet.name(), (CWidgetSetId)id), "widgetSetLoaded", event.toJson());
        aWidgetSet.sendNotifications();
    }

    @Nullable
    public CWidget findComponent(@NotNull Component aComponent) {
        return this.mWidgetSetList.findComponent(aComponent);
    }

    public void applyContextAttributes(@Nullable CTargetAddress aSender, @NotNull String aKey, @NotNull Object aValue) throws Exception {
        switch (aKey) {
            case "unmount": {
                CWidgetId widgetId;
                CEventUnmountWidget event = CEventUnmountWidget.create((Object)aValue);
                if (event == null || (widgetId = event.getWidgetId()) == null) break;
                this.getPlatformContext().invokeLater(() -> this.unmountWidget(aSender, event.getWidgetId()));
                break;
            }
            case "mount": {
                CEventMountWidgetSet event = CEventMountWidgetSet.create((Object)aValue);
                if (event == null) break;
                this.mountAndShowWidgetSet(event.getParent(), event.getWidgetSetToMount(), event.getOwner(), event.getWidgetToShow(), event.getTransactionId());
                break;
            }
            case "createwidget": {
                CEventCreateWidget event = CEventCreateWidget.create((Object)aValue);
                if (event == null) break;
                CEventLayoutConstraints evl = event.getConstraints();
                this.createWidget(event.getWidgetType(), event.getWidgetId(), event.getParentId(), evl);
                break;
            }
            case "removewidget": {
                CEventRemoveWidget event = CEventRemoveWidget.create((Object)aValue);
                if (event == null) break;
                this.removeWidget(event);
                break;
            }
            case "globalproperties": {
                CEventGlobalProperties event = CEventGlobalProperties.create((Object)aValue);
                if (event == null) break;
                this.handleGlobalPropertyJson(event);
                break;
            }
            case "showColorChooser": {
                break;
            }
            default: {
                LOG.warn("Unknown Client Context Attribute {}", new Object[]{aKey});
            }
        }
    }

    private void removeWidget(@NotNull CEventRemoveWidget aEvent) {
        CWidgetId widgetId = aEvent.getWidgetToRemove();
        CWidget widget = this.findWidget(widgetId);
        if (widget == null) {
            LOG.error("Remove widget {}: not found", new Object[]{widgetId});
            return;
        }
        CWidgetSet widgetSet = widget.getWidgetSet();
        widgetSet.remove(widget);
        Component component = widget.getComponent();
        Container parent = component.getParent();
        if (parent != null) {
            parent.remove(component);
        }
    }

    private void handleGlobalPropertyJson(@NotNull CEventGlobalProperties aEvent) {
        IGlobalPropertyHolder globalPropertyHolder = this.mPrivateContextFactory.getGlobalPropertyHolder();
        String json = aEvent.getJson();
        try {
            CJsonObject jo = this.mPrivateContextFactory.getJsonParser().parse(json, false);
            for (String key : jo.keys()) {
                Object value1 = jo.getValue(key);
                if (!(value1 instanceof CJsonObject)) continue;
                CJsonObject jo1 = (CJsonObject)value1;
                Object value2 = jo1.getValue("value");
                globalPropertyHolder.addVar(key, value2);
            }
        }
        catch (CException aE) {
            LOG.error((Throwable)aE, "Error parsing Global Property JSON");
        }
    }

    @Nullable
    public CWidget createWidget(@NotNull String aWidgetType, @NotNull CWidgetId aWidgetId, @Nullable CWidgetId aParentId, @Nullable CEventLayoutConstraints aConstraints) throws Exception {
        CWidget widget;
        CWidgetSetId widgetSetId;
        CWidgetSet widgetSet;
        CWidget widget1 = this.findWidget(aWidgetId);
        if (widget1 != null) {
            LOG.error("Can't create Widget {}, widget already created", new Object[]{aWidgetId});
            return null;
        }
        CWidget parent = null;
        if (aParentId != null) {
            parent = this.findWidget(aParentId);
        }
        if ((widgetSet = this.mWidgetSetList.get(widgetSetId = aWidgetId.getWidgetSetId())) == null) {
            LOG.error("Can't create Widget {} {}, widgetSet is unknown", new Object[]{aWidgetType, aWidgetId});
            return null;
        }
        IWidgetFactory widgetFactory = this.getWidgetFactoryRegistry().get(aWidgetType);
        if (widgetFactory != null && (widget = widgetFactory.createWidget(widgetSet, aWidgetId.getName(), new CJsonObject(true))) != null) {
            widgetSet.add(widget, parent);
            if (parent != null && aConstraints != null) {
                widget.getProperties().put("constraints", aConstraints);
                parent.addChildComponent(widget);
            }
            return widget;
        }
        return null;
    }

    public CWidgetSet mountAndShowWidgetSet(@Nullable CWidgetId aParent, @NotNull CWidgetSetId aWidgetSetIdToMount, @NotNull CTargetAddress aOwner, @Nullable String aToShow, @Nullable UUID aTransactionId) throws Exception {
        CWidgetSet widgetSet = this.mount(aParent, aWidgetSetIdToMount, aOwner, aTransactionId);
        if (widgetSet != null) {
            CWidgetSetId id = widgetSet.getId();
            if (CUtilString.isValid((String)aToShow)) {
                CWidgetId toShow = CWidgetId.create((String)aToShow, (CWidgetSetId)id);
                this.show(toShow);
            }
        }
        return widgetSet;
    }

    public void applyAttributes(@Nullable CTargetAddress aSender, @NotNull String aJson) throws CException {
        IJsonCommandParser parser = this.mPrivateContextFactory.getJsonCommandFactory().createParser();
        CListOfAttributes attributes = parser.parse(aJson);
        for (CAttributeEntry e : attributes.getAll()) {
            CWidgetId widgetId = e.getWidgetId();
            String key = e.getKey();
            Object value = e.getValue();
            if (CModelConstants.CONTEXT_WIDGET_ID.equals((Object)widgetId)) {
                try {
                    this.applyContextAttributes(aSender, key, value);
                }
                catch (Exception aE) {
                    LOG.error((Throwable)aE, "Error applying context attribute {} to {}", new Object[]{key, widgetId});
                }
                continue;
            }
            CWidget widget = this.findWidget(widgetId);
            if (widget == null) {
                LOG.error("Couldn't find widget {}", new Object[]{widgetId});
                continue;
            }
            SwingUtilities.invokeLater(() -> {
                try {
                    widget.getAttributeHandlerList().handleAttribute(key, value);
                }
                catch (Exception aE) {
                    LOG.error((Throwable)aE, "Error applying attribute {} to {}", new Object[]{key, widgetId});
                }
            });
        }
    }

    public void fileArrived(@NotNull CWidgetId aWidgetId, @NotNull String aRelativePath, @Nullable Object aToken, @NotNull File aFile) {
        CWidget widget = this.findWidget(aWidgetId);
        if (widget != null) {
            SwingUtilities.invokeLater(() -> widget.fileArrived(aRelativePath, aToken, aFile));
        }
    }

    public void fileArrived(@NotNull CWidgetId aWidgetId, @NotNull String aRelativePath, @Nullable Object aToken, byte[] aBytes) {
        CWidget widget = this.findWidget(aWidgetId);
        if (widget != null) {
            SwingUtilities.invokeLater(() -> widget.fileArrived(aRelativePath, aToken, aBytes));
        }
    }

    public void fileArrived(@NotNull CWidgetId aWidgetId, @NotNull String aRelativePath, @Nullable Object aToken, @NotNull ImageIcon aImage) {
        SwingUtilities.invokeLater(() -> {
            CWidget widget = this.findWidget(aWidgetId);
            if (widget != null) {
                widget.fileArrived(aRelativePath, aToken, aImage);
            }
        });
    }

    public void dumpWidgetSets(@Nullable String aFilter) {
        this.mWidgetSetList.dump(aFilter);
    }
}

