/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.writer.xml;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.db.ETransportDirection;
import de.sillysky.nyssr.record.db.IRecordDatabase;
import de.sillysky.nyssr.record.db.IRecordEntry;
import de.sillysky.nyssr.record.db.ISlotRecord;
import de.sillysky.nyssr.record.writer.xml.IRecordWriterXml;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Serializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRecordWriterXml
implements IService,
IRecordWriterXml {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordWriterXml.class);

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IRecordWriterXml.class, (Object)this);
    }

    private Collection<IRecordEntry> createRecordList(@NotNull IRecordDatabase aDatabase, @Nullable Collection<String> aRecordIdList) {
        ArrayList<IRecordEntry> records;
        if (aRecordIdList == null) {
            records = aDatabase.getRecords();
        } else {
            records = new ArrayList<IRecordEntry>();
            for (String idString : aRecordIdList) {
                IId id = CIdFactory.fromObject((Object)idString);
                IRecordEntry record = aDatabase.getRecord(id);
                if (record == null) {
                    LOG.error("Record XML Writer: Record {} not found. Skip");
                    continue;
                }
                records.add(record);
            }
        }
        return records;
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    private Document getDocument(@NotNull IRecordDatabase aDatabase, @Nullable Collection<String> aRecordIdList) {
        Element root = new Element("records");
        Collection<IRecordEntry> recordList = this.createRecordList(aDatabase, aRecordIdList);
        for (IRecordEntry record : recordList) {
            Element elementRecord = new Element("record");
            root.appendChild((Node)elementRecord);
            String value = record.getId().valueToString();
            Attribute attr = new Attribute("id", value);
            elementRecord.addAttribute(attr);
            value = record.getName();
            attr = new Attribute("name", value);
            elementRecord.addAttribute(attr);
            value = Boolean.toString(record.isNanoService());
            attr = new Attribute("isService", value);
            elementRecord.addAttribute(attr);
            value = Boolean.toString(record.hasOtherSlots());
            attr = new Attribute("hasOtherSlots", value);
            elementRecord.addAttribute(attr);
            value = record.getAccessType().name();
            attr = new Attribute("access", value);
            elementRecord.addAttribute(attr);
            String desc = record.getDescription();
            Element elementDesc = new Element("description");
            elementDesc.appendChild(desc);
            elementRecord.appendChild((Node)elementDesc);
            Collection namespaces = record.getNamespaces();
            for (String namespace : namespaces) {
                Element elementNs = new Element("namespaces");
                elementNs.appendChild(namespace);
                elementRecord.appendChild((Node)elementNs);
            }
            Iterator itSlot = record.getSlots();
            while (itSlot.hasNext()) {
                ISlotRecord slot = (ISlotRecord)itSlot.next();
                Element elementSlot = new Element("slot");
                elementRecord.appendChild((Node)elementSlot);
                value = slot.getKey();
                attr = new Attribute("key", value);
                elementSlot.addAttribute(attr);
                value = slot.getName();
                attr = new Attribute("name", value);
                elementSlot.addAttribute(attr);
                value = slot.getSlotTypeName();
                attr = new Attribute("type", value);
                elementSlot.addAttribute(attr);
                ETransportDirection direction = slot.getTransportDirection();
                value = direction.toString();
                attr = new Attribute("direction", value);
                elementSlot.addAttribute(attr);
                value = Boolean.toString(slot.isMandatory());
                attr = new Attribute("mandatory", value);
                elementSlot.addAttribute(attr);
                desc = slot.getDescription();
                elementDesc = new Element("description");
                elementDesc.appendChild(desc);
                elementSlot.appendChild((Node)elementDesc);
            }
        }
        return new Document(root);
    }

    @Override
    public String getFormattedXml(@NotNull IRecordDatabase aDatabase, @Nullable Collection<String> aRecordIdList) throws CException {
        Document doc = this.getDocument(aDatabase, aRecordIdList);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Serializer serializer = new Serializer((OutputStream)baos, "ISO-8859-1");
            serializer.setIndent(4);
            serializer.write(doc);
            return baos.toString("ISO-8859-1");
        }
        catch (Exception e) {
            throw new CException((Throwable)e);
        }
    }

    @Override
    public String getUnformattedXml(@NotNull IRecordDatabase aDatabase, @Nullable Collection<String> aRecordIdList) {
        Document doc = this.getDocument(aDatabase, aRecordIdList);
        return doc.toXML();
    }

    @Override
    public void writeXml(@NotNull IRecordDatabase aDb, @NotNull Path aFilePath, @Nullable Collection<String> aRecordIdList) throws CException {
        Document doc = this.getDocument(aDb, aRecordIdList);
        try {
            File file = aFilePath.toFile();
            FileOutputStream fos = new FileOutputStream(file);
            Serializer serializer = new Serializer((OutputStream)fos, "ISO-8859-1");
            serializer.setIndent(4);
            serializer.write(doc);
        }
        catch (IOException ex) {
            LOG.error((Throwable)ex, "Error writing XML");
            throw new CException(2105).append((Object)ex);
        }
    }
}

