/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.record.parser.xml;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.record.db.CRecordEntry;
import de.sillysky.nyssr.impl.record.db.CSlotEntry;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.record.db.EAccess;
import de.sillysky.nyssr.record.db.ETransportDirection;
import de.sillysky.nyssr.record.db.IRecordDatabase;
import de.sillysky.nyssr.record.db.IRecordEntry;
import de.sillysky.nyssr.record.db.ISlotRecord;
import de.sillysky.nyssr.record.parser.xml.IRecordParserXml;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.slot.ISlotFactory;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Path;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import org.jetbrains.annotations.NotNull;

public class CRecordParserXml
implements IRecordParserXml,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRecordParserXml.class);

    private static CRecordEntry parseRecord(ISlotFactory aSlotFactory, Element aElementMessage) throws CException {
        boolean isService;
        Attribute attribute = aElementMessage.getAttribute("isService");
        if (attribute == null) {
            isService = false;
        } else {
            String strIsService = attribute.getValue();
            isService = Boolean.parseBoolean(strIsService);
        }
        attribute = aElementMessage.getAttribute("id");
        if (attribute == null) {
            throw new CException(2105).append("Missing message attribute <").append("id").append(">");
        }
        String strId = attribute.getValue();
        attribute = aElementMessage.getAttribute("name");
        if (attribute == null) {
            throw new CException(2105).append("Missing message attribute <").append("name").append(">");
        }
        String strName = attribute.getValue();
        EAccess access = EAccess.PUBLIC;
        attribute = aElementMessage.getAttribute("access");
        if (attribute != null) {
            String value = attribute.getValue();
            access = EAccess.valueOf((String)value);
        }
        CRecordEntry recordEntry = new CRecordEntry(strId, strName, isService, access);
        boolean hasOtherSlots = false;
        attribute = aElementMessage.getAttribute("hasOtherSlots");
        if (attribute != null) {
            String strHasOtherSlots = attribute.getValue();
            hasOtherSlots = Boolean.parseBoolean(strHasOtherSlots);
        }
        recordEntry.setHasOtherSlots(hasOtherSlots);
        Elements childElements = aElementMessage.getChildElements();
        block10: for (int i = 0; i < childElements.size(); ++i) {
            String childName;
            Element child = childElements.get(i);
            switch (childName = child.getLocalName()) {
                case "namespaces": {
                    String namespace = child.getValue();
                    recordEntry.addNamespace(namespace);
                    continue block10;
                }
                case "slot": {
                    CRecordParserXml.parseSlot(aSlotFactory, (IRecordEntry)recordEntry, child);
                    continue block10;
                }
                case "description": {
                    String desc = child.getValue();
                    recordEntry.setDescription(desc);
                    continue block10;
                }
            }
        }
        return recordEntry;
    }

    private static void parseSlot(ISlotFactory aSlotFactory, IRecordEntry aRecord, Element aElement) throws CException {
        Attribute attribute = aElement.getAttribute("key");
        if (attribute == null) {
            throw new CException(2105).append("Missing slot attribute <").append("key").append(">");
        }
        String strKey = attribute.getValue();
        ETransportDirection direction = ETransportDirection.REQUEST;
        attribute = aElement.getAttribute("direction");
        if (attribute != null) {
            String strDirection = attribute.getValue();
            direction = ETransportDirection.valueOf((String)strDirection);
        } else {
            String strAnswer;
            boolean isAnswer;
            attribute = aElement.getAttribute("answer");
            if (attribute != null && (isAnswer = Boolean.parseBoolean(strAnswer = attribute.getValue()))) {
                direction = ETransportDirection.ANSWER;
            }
        }
        attribute = aElement.getAttribute("type");
        if (attribute == null) {
            throw new CException(2105).append("Missing slot attribute <").append("type").append(">");
        }
        String strDataType = attribute.getValue();
        boolean mandatory = false;
        attribute = aElement.getAttribute("mandatory");
        if (attribute != null) {
            String strMandatory = attribute.getValue();
            mandatory = Boolean.parseBoolean(strMandatory);
        }
        if ((attribute = aElement.getAttribute("name")) == null) {
            throw new CException(2105).append("Missing slot attribute <").append("name").append(">");
        }
        String name = attribute.getValue();
        CSlotEntry slot = new CSlotEntry(aSlotFactory, strKey, strDataType, name, direction, mandatory);
        Elements childElements = aElement.getChildElements();
        for (int i = 0; i < childElements.size(); ++i) {
            Element element = childElements.get(i);
            String localName = element.getLocalName();
            if (!"description".equals(localName)) continue;
            String desc = element.getValue();
            slot.setDescription(desc);
        }
        aRecord.addSlot((ISlotRecord)slot);
    }

    private static void read(IRecordDatabase aRecordDatabase, Document aDocument) throws CException {
        Element root = aDocument.getRootElement();
        if (!"records".equalsIgnoreCase(root.getLocalName())) {
            throw new CException(2105).append("Wrong format: no root <>").append("records").append(">");
        }
        int count = 0;
        int ignored = 0;
        Elements recordList = root.getChildElements("record", null);
        for (int i = 0; i < recordList.size(); ++i) {
            Element elementEntry = recordList.get(i);
            CRecordEntry record = CRecordParserXml.parseRecord(aRecordDatabase.getSlotFactory(), elementEntry);
            boolean imported = aRecordDatabase.addRecord((IRecordEntry)record);
            if (imported) {
                ++count;
                continue;
            }
            ++ignored;
        }
        LOG.info("{} data records imported into record database. {} data records ignored.", new Object[]{count, ignored});
    }

    static void read(IRecordDatabase aRecordDatabase, InputStream aMessageDbStream) throws CException {
        try {
            Builder builder = new Builder();
            Document doc = builder.build(aMessageDbStream);
            CRecordParserXml.read(aRecordDatabase, doc);
        }
        catch (CException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error reading the configuration: ");
        }
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.registerService(IRecordParserXml.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    public void parseFile(@NotNull IRecordDatabase aDb, @NotNull Path aPath) throws CException {
        File file = aPath.toFile();
        if (!file.exists()) {
            throw new CException(2202).append("File not found: ").append(aPath.toString());
        }
        try {
            FileReader reader = new FileReader(file);
            Builder builder = new Builder();
            Document doc = builder.build((Reader)reader);
            CRecordParserXml.read(aDb, doc);
        }
        catch (CException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error reading the configuration: ");
        }
    }
}

