/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.dialog.monitor.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyDialogOpened
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"588d17f7-1065-40a3-ab7a-2729b320a361");
    public static final String NAME = "NotifyDialogOpened";
    public static final String DESCRIPTION = "Notification that a RemoteSkin dialog has been created.";
    public static final String SLOT_CLIENT_CONTEXT_ADDRESS = "4";
    public static final String SLOT_CLIENT_CONTEXT_ID = "3";
    public static final String SLOT_DIALOG_TYPE = "7";
    public static final String SLOT_ID = "1";
    public static final String SLOT_PARENT_WIDGET_ID = "6";
    public static final String SLOT_PLATFORM_TYPE = "5";
    public static final String SLOT_SESSION_TOKEN = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getClientContextAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CLIENT_CONTEXT_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static IId getClientContextId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CLIENT_CONTEXT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static String getDialogType(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DIALOG_TYPE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static UUID getId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static CWidgetId getParentWidgetId(@NotNull CRecord aRecord, CWidgetId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PARENT_WIDGET_ID);
        if (slot == null) {
            return aDefault;
        }
        return (CWidgetId)slot.getValue();
    }

    public static String getPlatformType(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PLATFORM_TYPE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getSessionToken(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SESSION_TOKEN);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static void setClientContextAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_CLIENT_CONTEXT_ADDRESS, slot);
    }

    public static void setClientContextId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_CLIENT_CONTEXT_ID, slot);
    }

    public static void setDialogType(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_DIALOG_TYPE, slot);
    }

    public static void setId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_ID, slot);
    }

    public static void setParentWidgetId(@NotNull CRecord aRecord, CWidgetId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.WIDGET_ID, (Object)aValue);
        aRecord.addSlot(SLOT_PARENT_WIDGET_ID, slot);
    }

    public static void setPlatformType(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_PLATFORM_TYPE, slot);
    }

    public static void setSessionToken(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_SESSION_TOKEN, slot);
    }
}

