/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.file.store.service;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreFile;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreGetFileInfo;
import de.sillysky.nyssr.impl.file.store.database.CFileEntry;
import de.sillysky.nyssr.impl.file.store.service.CFileStore;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import org.jetbrains.annotations.NotNull;

class CIncomingGetFileHandler {
    private static final ILogger LOG = CLoggerFactory.getLogger(CIncomingGetFileHandler.class);
    private final CFileStore mFileStore;

    CIncomingGetFileHandler(@NotNull CFileStore aFileStore) {
        this.mFileStore = aFileStore;
    }

    void processIncomingGetFile(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        CRecord record = CRecordFileStoreGetFileInfo.getFile((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)record, (String)"File Record Missing", (Object[])new Object[0]);
        CUtilCheck.checkEqual((Object)record.getId(), (Object)CRecordFileStoreFile.ID, (String)"Wrong File Record ID", (Object[])new Object[0]);
        String path = CRecordFileStoreFile.getPath((CRecord)record, null);
        String hash = CRecordFileStoreFile.getHash((CRecord)record, null);
        LOG.debug("Get file info, path={}, hash={}", new Object[]{path, hash});
        CFileEntry e = this.mFileStore.getFileList().get(path, hash);
        if (e == null) {
            LOG.debug("File unknown: {}", new Object[]{path});
            aEnvelope.setResult(5, "File not found");
        } else {
            e.toRecord(record);
            LOG.debug("File found: {}", new Object[]{e});
            aEnvelope.setResultSuccess();
        }
    }
}

