/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.app.factory.collector.CAppCollectorUtils;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationEntry;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationFactoryEntry;
import de.sillysky.nyssr.record.CRecord;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CApplicationFactoryList {
    private Map<UUID, CApplicationFactoryEntry> mMap = new HashMap<UUID, CApplicationFactoryEntry>();

    CApplicationFactoryList() {
    }

    boolean add(@NotNull CApplicationEntry aApplicationEntry, @NotNull CTargetAddress aFactoryAddress) {
        UUID applicationId = aApplicationEntry.getApplicationId();
        CApplicationFactoryEntry entry = this.mMap.get(applicationId);
        if (entry == null) {
            entry = new CApplicationFactoryEntry(aApplicationEntry);
            this.mMap.put(applicationId, entry);
        }
        return entry.addFactory(aFactoryAddress);
    }

    boolean removeFactory(@NotNull UUID aApplicationId, @NotNull CTargetAddress aFactoryAddress) {
        CApplicationFactoryEntry entry = this.mMap.get(aApplicationId);
        if (entry != null) {
            return entry.removeFactory(aFactoryAddress);
        }
        return false;
    }

    @Nullable
    CTargetAddress getNextFactoryAddress(@NotNull UUID aApplicationId) {
        CApplicationFactoryEntry entry = this.mMap.get(aApplicationId);
        if (entry != null) {
            return entry.getNextFactory();
        }
        return null;
    }

    CRecord[] getApplicationListForPermission(String[] aPermissions, @NotNull String aPlatform) throws CException {
        List<CRecord> list = CAppCollectorUtils.fill(this.mMap.values(), aPermissions, aPlatform);
        return list.toArray(new CRecord[0]);
    }

    public CApplicationFactoryEntry getFactoryEntry(@Nullable UUID aApplicationId) {
        return aApplicationId == null ? null : this.mMap.get(aApplicationId);
    }

    public boolean notifyRemoteNodeRemoved(@NotNull CNodeAddress aNodeAddress) {
        boolean changes = false;
        for (CApplicationFactoryEntry factory : this.mMap.values()) {
            changes |= factory.removeNode(aNodeAddress);
        }
        return changes;
    }

    public boolean notifyTargetRemoved(CTargetAddress aAddress) {
        boolean changes = false;
        for (CApplicationFactoryEntry factory : this.mMap.values()) {
            changes |= factory.removeFactory(aAddress);
        }
        return changes;
    }
}

