/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.stream.hook;

import de.sillysky.nyssr.network.stream.hook.IStreamMonitor;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class CMonitorFilterOutputStream
extends FilterOutputStream {
    private final Set<IStreamMonitor> mMonitors;

    CMonitorFilterOutputStream(OutputStream aStream, Set<IStreamMonitor> aMonitors) {
        super(aStream);
        this.mMonitors = aMonitors;
    }

    @Override
    public void write(byte @NotNull [] aByte) throws IOException {
        for (IStreamMonitor monitor : this.mMonitors) {
            monitor.tx(aByte, 0, aByte.length);
        }
        super.write(aByte);
    }

    @Override
    public void write(byte @NotNull [] aByte, int aOffset, int aLength) throws IOException {
        for (IStreamMonitor monitor : this.mMonitors) {
            monitor.tx(aByte, aOffset, aLength);
        }
        super.write(aByte, aOffset, aLength);
    }

    @Override
    public void write(int aByte) throws IOException {
        for (IStreamMonitor monitor : this.mMonitors) {
            monitor.tx(new byte[]{(byte)aByte}, 0, 1);
        }
        super.write(aByte);
    }
}

