/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.builder.message;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketBuilder;
import de.sillysky.nyssr.network.packets.IPacketBuilderRegistry;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

final class CPacketBuilderMessage
implements IPacketBuilder,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketBuilderMessage.class);

    CPacketBuilderMessage() {
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IPacketBuilderRegistry.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketBuilderRegistry packetBuilderRegistry = (IPacketBuilderRegistry)aServiceRegistry.getService(IPacketBuilderRegistry.class);
        assert (packetBuilderRegistry != null);
        packetBuilderRegistry.registerPacketBuilder(this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketBuilderRegistry packetBuilderRegistry = (IPacketBuilderRegistry)aServiceRegistry.getService(IPacketBuilderRegistry.class);
        if (packetBuilderRegistry != null) {
            packetBuilderRegistry.deregisterPacketBuilder(this);
        }
    }

    @Override
    public char getType() {
        return 'M';
    }

    @Override
    public void pack(IPacket aPacket, CNodeInfoDto aNodeInfo) throws CException {
        if (aPacket instanceof CPacketMessage) {
            CPacketMessage packet = (CPacketMessage)aPacket;
            CMessage message = packet.getMessage();
            if (message == null) {
                throw new CException(7).append("Message is null.");
            }
            try (ByteArrayOutputStream s1 = new ByteArrayOutputStream();
                 DataOutputStream s2 = new DataOutputStream(s1);){
                message.toStream((DataOutput)s2);
                s2.flush();
                s2.close();
                byte[] data = s1.toByteArray();
                packet.setPayload(data);
                String builderFlags = packet.getBuilderSequence();
                packet.setBuilderSequence(builderFlags + this.getType());
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "Error packing message: {}", new Object[]{message});
                throw new CException((Throwable)e);
            }
        }
    }

    @Override
    public void unpack(IPacket aPacket, CNodeInfoDto aNodeInfo) throws CException {
        CPacketMessage packet;
        byte[] payload;
        if (aPacket instanceof CPacketMessage && (payload = (packet = (CPacketMessage)aPacket).getPayload()) != null) {
            try (ByteArrayInputStream bais = new ByteArrayInputStream(payload);
                 DataInputStream dis = new DataInputStream(bais);){
                CMessage msg = CMessage.fromStream((DataInput)dis);
                dis.close();
                packet.setMessage(msg);
                packet.removeBuilderFlag(this.getType());
                packet.setPayload(null);
            }
            catch (IOException e) {
                LOG.error((Throwable)e, "Error unpacking message: {}", new Object[]{aPacket});
                throw new CException((Throwable)e);
            }
        }
    }
}

