/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.packet.builder.aes;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.network.nodeinfo.CNodeInfoUtil;
import de.sillysky.nyssr.impl.network.packet.factory.message.CPacketMessage;
import de.sillysky.nyssr.impl.network.util.CUtilAes;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfoDto;
import de.sillysky.nyssr.network.packets.IPacket;
import de.sillysky.nyssr.network.packets.IPacketBuilder;
import de.sillysky.nyssr.network.packets.IPacketBuilderRegistry;
import de.sillysky.nyssr.network.packets.IPacketMessage;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import javax.crypto.SecretKey;
import org.jetbrains.annotations.NotNull;

final class CPacketBuilderAes
implements IPacketBuilder,
IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CPacketBuilderAes.class);

    CPacketBuilderAes() {
    }

    public static void getDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IPacketBuilderRegistry.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketBuilderRegistry packetBuilderRegistry = (IPacketBuilderRegistry)aServiceRegistry.getService(IPacketBuilderRegistry.class);
        assert (packetBuilderRegistry != null);
        packetBuilderRegistry.registerPacketBuilder(this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IPacketBuilderRegistry packetBuilderRegistry = (IPacketBuilderRegistry)aServiceRegistry.getService(IPacketBuilderRegistry.class);
        if (packetBuilderRegistry != null) {
            packetBuilderRegistry.deregisterPacketBuilder(this);
        }
    }

    @Override
    public char getType() {
        return 'A';
    }

    @Override
    public void pack(IPacket aPacket, CNodeInfoDto aNodeInfo) throws CException {
        if (aPacket instanceof CPacketMessage) {
            CPacketMessage packet = (CPacketMessage)aPacket;
            byte[] payload = packet.getPayload();
            if (payload == null) {
                throw new CException(7).append("Payload is null.");
            }
            SecretKey key = aNodeInfo.getHisSessionKey();
            if (key != null) {
                byte[] encrypted = CUtilAes.pack(payload, key, (IPacketMessage)aPacket);
                String builderFlags = packet.getBuilderSequence();
                packet.setBuilderSequence(builderFlags + this.getType());
                packet.setPayload(encrypted);
            }
        }
    }

    @Override
    public void unpack(IPacket aPacket, CNodeInfoDto aNodeInfo) throws CException {
        if (aPacket instanceof CPacketMessage) {
            CPacketMessage packet = (CPacketMessage)aPacket;
            byte[] payload = packet.getPayload();
            if (payload == null) {
                throw new CException(7).append("Payload is null.");
            }
            SecretKey key = CNodeInfoUtil.getMySessionKey(aNodeInfo);
            if (key == null) {
                throw new CException(26).append("No Session Key to unpack for node ").append((Object)aNodeInfo.getNodeAddress());
            }
            byte[] decrypted = CUtilAes.unpack(payload, key, (IPacketMessage)aPacket);
            packet.setPayload(decrypted);
            packet.removeBuilderFlag(this.getType());
        }
    }
}

